/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.soapextensions;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.artifact.ArtifactIDFactory;
import com.microsoft.tfs.core.clients.versioncontrol.PropertyUtils;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Change;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.CheckinNote;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PolicyOverrideInfo;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.PropertyValue;
import com.microsoft.tfs.core.clients.workitem.WorkItem;
import com.microsoft.tfs.core.clients.workitem.WorkItemClient;
import com.microsoft.tfs.core.clients.workitem.query.Query;
import com.microsoft.tfs.core.clients.workitem.query.WorkItemCollection;
import com.microsoft.tfs.core.exceptions.TECoreException;
import com.microsoft.tfs.core.internal.wrappers.WebServiceObjectWrapper;
import com.microsoft.tfs.core.internal.wrappers.WrapperUtils;
import com.microsoft.tfs.util.Check;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import ms.tfs.versioncontrol.clientservices._03._Change;
import ms.tfs.versioncontrol.clientservices._03._Changeset;
import ms.tfs.versioncontrol.clientservices._03._PropertyValue;

public final class Changeset
extends WebServiceObjectWrapper {
    public static final int MAX = Integer.MAX_VALUE;
    private Change[] changes;
    private WorkItem[] workItems = null;

    public static Calendar getDefaultDate() {
        GregorianCalendar cal = new GregorianCalendar(1, 0, 1, 0, 0, 0);
        ((Calendar)cal).setTimeZone(TimeZone.getTimeZone("GMT"));
        return cal;
    }

    public Changeset() {
        this(new _Changeset());
    }

    public Changeset(_Changeset changeset) {
        super(changeset);
        String ownerDisplayName;
        String committerDisplayName;
        if (changeset.getChanges() != null) {
            this.changes = (Change[])WrapperUtils.wrap(Change.class, changeset.getChanges());
        }
        if ((committerDisplayName = changeset.getCmtrdisp()) == null || committerDisplayName.length() == 0) {
            changeset.setCmtrdisp(changeset.getCmtr());
        }
        if ((ownerDisplayName = changeset.getOwnerdisp()) == null || ownerDisplayName.length() == 0) {
            changeset.setOwnerdisp(changeset.getOwner());
        }
    }

    public Changeset(Changeset changeset, Change change) {
        this(changeset.getWebServiceObject());
        this.changes = new Change[]{change};
    }

    public Changeset(String owner, String comment, CheckinNote checkinNote, PolicyOverrideInfo policyOverride) {
        this(null, comment, checkinNote, policyOverride, null, null, null, -1, owner, null, null);
    }

    public Changeset(Change[] changes, String comment, CheckinNote checkinNote, PolicyOverrideInfo policyOverride, String committer, String committerDisplayName, Calendar date, int changeSetID, String owner, String ownerDisplayName, PropertyValue[] properties) {
        this(new _Changeset(committer, committerDisplayName, date != null ? date : Changeset.getDefaultDate(), changeSetID, owner, ownerDisplayName, comment, checkinNote != null ? checkinNote.getWebServiceObject() : null, policyOverride != null ? policyOverride.getWebServiceObject() : null, properties != null ? (_PropertyValue[])WrapperUtils.unwrap(_PropertyValue.class, properties) : null, changes != null ? (_Change[])WrapperUtils.unwrap(_Change.class, changes) : null));
    }

    public _Changeset getWebServiceObject() {
        this.getWebServiceObjectInternal().setChanges((_Change[])WrapperUtils.unwrap(_Change.class, this.changes));
        return this.getWebServiceObjectInternal();
    }

    private _Changeset getWebServiceObjectInternal() {
        return (_Changeset)this.webServiceObject;
    }

    public synchronized void setWorkItems(WorkItem[] workItems) {
        Check.notNull(workItems, "workItems");
        this.workItems = workItems;
    }

    public synchronized WorkItem[] getWorkItems() {
        if (this.getWebServiceObjectInternal().getCset() < 1) {
            throw new TECoreException(Messages.getString("Changeset.AnArtifactURICannotBeCreatedForAnUncommittedChangeset"));
        }
        if (this.workItems == null) {
            return new WorkItem[0];
        }
        return this.workItems;
    }

    public synchronized WorkItem[] getWorkItems(WorkItemClient workItemClient) throws TECoreException {
        Check.notNull(workItemClient, "workItemClient");
        if (this.workItems == null) {
            if (this.getWebServiceObjectInternal().getCset() < 1) {
                throw new TECoreException(Messages.getString("Changeset.AnArtifactURICannotBeCreatedForAnUncommittedChangeset"));
            }
            Query query = workItemClient.createReferencingQuery(ArtifactIDFactory.newChangesetArtifactID(this.getWebServiceObjectInternal().getCset()).encodeURI().toString());
            query.getDisplayFieldList().add("System.WorkItemType");
            query.getDisplayFieldList().add("System.State");
            query.getDisplayFieldList().add("System.AssignedTo");
            query.getDisplayFieldList().add("System.Title");
            WorkItemCollection itemCollection = query.runQuery();
            if (itemCollection != null) {
                int size = itemCollection.size();
                this.workItems = new WorkItem[size];
                for (int i = 0; i < size; ++i) {
                    this.workItems[i] = itemCollection.getWorkItem(i);
                }
            } else {
                this.workItems = new WorkItem[0];
            }
        }
        return this.workItems;
    }

    public Change[] getChanges() {
        return this.changes;
    }

    public void setChanges(Change[] changes) {
        this.changes = changes;
    }

    public String getComment() {
        return this.getWebServiceObjectInternal().getComment();
    }

    public void setComment(String comment) {
        this.getWebServiceObjectInternal().setComment(comment);
    }

    public CheckinNote getCheckinNote() {
        return new CheckinNote(this.getWebServiceObjectInternal().getCheckinNote());
    }

    public void setCheckinNote(CheckinNote checkinNote) {
        this.getWebServiceObjectInternal().setCheckinNote(checkinNote.getWebServiceObject());
    }

    public PolicyOverrideInfo getPolicyOverride() {
        return new PolicyOverrideInfo(this.getWebServiceObjectInternal().getPolicyOverride());
    }

    public void setPolicyOverride(PolicyOverrideInfo policyOverride) {
        this.getWebServiceObjectInternal().setPolicyOverride(policyOverride.getWebServiceObject());
    }

    public String getCommitter() {
        return this.getWebServiceObjectInternal().getCmtr();
    }

    public void setCommitter(String committer) {
        this.getWebServiceObjectInternal().setCmtr(committer);
    }

    public String getCommitterDisplayName() {
        return this.getWebServiceObjectInternal().getCmtrdisp();
    }

    public void setCommitterDisplayName(String committer) {
        this.getWebServiceObjectInternal().setCmtrdisp(committer);
    }

    public Calendar getDate() {
        return this.getWebServiceObjectInternal().getDate();
    }

    public void setDate(Calendar date) {
        this.getWebServiceObjectInternal().setDate(date);
    }

    public int getChangesetID() {
        return this.getWebServiceObjectInternal().getCset();
    }

    public void setChangesetID(int changesetID) {
        this.getWebServiceObjectInternal().setCset(changesetID);
    }

    public String getOwner() {
        return this.getWebServiceObjectInternal().getOwner();
    }

    public void setOwner(String owner) {
        this.getWebServiceObjectInternal().setOwner(owner);
    }

    public String getOwnerDisplayName() {
        return this.getWebServiceObjectInternal().getOwnerdisp();
    }

    public void setOwnerDisplayName(String owner) {
        this.getWebServiceObjectInternal().setOwnerdisp(owner);
    }

    public PropertyValue[] getPropertyValues() {
        return PropertyUtils.selectUnique((PropertyValue[])WrapperUtils.wrap(PropertyValue.class, this.getWebServiceObjectInternal().getProperties()));
    }

    public void sortChanges() {
        Arrays.sort(this.changes);
    }
}

