/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.clients.versioncontrol.exceptions.VersionControlException;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.InternalWorkspaceConflictInfo;
import com.microsoft.tfs.core.clients.versioncontrol.workspacecache.internal.InternalCache;
import com.microsoft.tfs.jni.filelock.TFSFileLock;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.xml.DOMCreateUtils;
import com.microsoft.tfs.util.xml.DOMSerializeUtils;
import com.microsoft.tfs.util.xml.DOMUtils;
import com.microsoft.tfs.util.xml.XMLException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InternalCacheLoader {
    private static final Log log = LogFactory.getLog(InternalCacheLoader.class);
    private static final int LOCK_ACQUIRE_TIMEOUT_MILLISECONDS = 10000;
    public static final String FILE_NAME = "VersionControl.config";
    private static final String XML_VERSION_CONTROL_SERVER = "VersionControlServer";
    private static final String XML_SERVERS = "Servers";

    public static InternalCache loadConfig(InternalCache currentCache, boolean dataDirectoryExists, AtomicReference<InternalWorkspaceConflictInfo[]> conflictingWorkspaces, Object workstationMutex, File file) {
        Check.notNull(conflictingWorkspaces, "conflictingWorkspaces");
        Check.notNull(workstationMutex, "workstationMutex");
        Check.notNull(file, "file");
        conflictingWorkspaces.set(InternalWorkspaceConflictInfo.EMPTY_ARRAY);
        if (!dataDirectoryExists) {
            return new InternalCache(workstationMutex);
        }
        TFSFileLock lock = InternalCacheLoader.acquireLockOrThrow(file);
        Document config = null;
        try {
            config = InternalCacheLoader.readCacheAsDocument(file);
            if (config == null) {
                currentCache = new InternalCache(workstationMutex);
            } else if (currentCache == null) {
                currentCache = new InternalCache(workstationMutex);
                currentCache.load(DOMUtils.getFirstChildElement(config.getDocumentElement(), XML_SERVERS));
            } else {
                currentCache.merge(DOMUtils.getFirstChildElement(config.getDocumentElement(), XML_SERVERS), conflictingWorkspaces);
            }
        }
        catch (XMLException e) {
            log.warn((Object)MessageFormat.format(Messages.getString("InternalCacheLoader.InvalidCacheFileFormat"), file), (Throwable)e);
            throw new VersionControlException(MessageFormat.format(Messages.getString("InternalCacheLoader.InvalidCacheFileFormat"), file), e);
        }
        finally {
            lock.release();
            lock.close();
        }
        return currentCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfigIfDirty(InternalCache internalCache, AtomicReference<InternalWorkspaceConflictInfo[]> conflictingWorkspaces, Object workstationMutex, File file) {
        Check.notNull(conflictingWorkspaces, "conflictingWorkspaces");
        Check.notNull(workstationMutex, "workstationMutex");
        Check.notNull(file, "file");
        conflictingWorkspaces.set(InternalWorkspaceConflictInfo.EMPTY_ARRAY);
        if (!internalCache.isDirty()) {
            return;
        }
        Document config = DOMCreateUtils.newDocument(XML_VERSION_CONTROL_SERVER);
        Element rootNode = config.getDocumentElement();
        Object object = workstationMutex;
        synchronized (object) {
            TFSFileLock lock = InternalCacheLoader.acquireLockOrThrow(file);
            try {
                Document oldConfig = InternalCacheLoader.readCacheAsDocument(file);
                Element oldCacheNode = null;
                if (oldConfig != null) {
                    oldCacheNode = DOMUtils.getFirstChildElement(oldConfig.getDocumentElement(), XML_SERVERS);
                }
                Element cacheNode = DOMUtils.appendChild(rootNode, XML_SERVERS);
                internalCache.save(oldCacheNode, cacheNode, conflictingWorkspaces);
                if (!file.exists() && !file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                try {
                    FileOutputStream stream = new FileOutputStream(file);
                    DOMSerializeUtils.serializeToStream(config, stream, "UTF-8", 2);
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            finally {
                lock.release();
                lock.close();
            }
            internalCache.markClean();
        }
    }

    private static Document readCacheAsDocument(File file) {
        Check.notNull(file, "file");
        try {
            FileInputStream stream = new FileInputStream(file);
            return DOMCreateUtils.parseStream(stream, "UTF-8", 0);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (XMLException e) {
            log.warn((Object)MessageFormat.format(Messages.getString("InternalCacheLoader.InvalidCacheFileFormat"), file), (Throwable)e);
            throw new VersionControlException(MessageFormat.format(Messages.getString("InternalCacheLoader.InvalidCacheFileFormat"), file), e);
        }
    }

    private static TFSFileLock acquireLockOrThrow(File file) throws VersionControlException {
        Check.notNull(file, "file");
        TFSFileLock lock = new TFSFileLock(file.getAbsolutePath());
        if (!lock.acquire(10000)) {
            lock.close();
            throw new VersionControlException(Messages.getString("InternalCacheLoader.CouldNotLockCacheFile"));
        }
        return lock;
    }
}

