/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.webservices;

import com.microsoft.tfs.util.Check;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class SecurityIdentifier {
    public static final int REVISION = 1;
    public static final byte MAX_SUB_AUTHORITIES = 15;
    private static final BigInteger MAX_DECIMAL_AUTHORITY_VALUE = new BigInteger("4294967296");
    private static final long MAX_SUBAUTHORITY_VALUE = 0x100000000L;
    private static final int MIN_BINARY_LENGTH = 8;
    private static final int MIN_SDDL_SEGMENTS = 3;
    private static final int MAX_SDDL_SEGMENTS = 18;
    private final byte[] binaryForm;
    private final String sddlForm;
    private final BigInteger authority;
    private final long[] subAuthorities;

    public SecurityIdentifier(byte[] binaryForm, int offset) {
        int i;
        Check.notNull(binaryForm, "binaryForm");
        Check.isTrue(binaryForm.length - offset >= 8, "Binary form array after offset too small to hold a security identifier");
        byte revision = binaryForm[offset];
        SecurityIdentifier.checkRevision(revision);
        byte subAuthorityCount = binaryForm[offset + 1];
        SecurityIdentifier.checkSubAuthorityCount(subAuthorityCount);
        int length = 8 + subAuthorityCount * 4;
        this.binaryForm = new byte[length];
        for (i = 0; i < length; ++i) {
            this.binaryForm[i] = binaryForm[offset + i];
        }
        this.authority = new BigInteger(new byte[]{binaryForm[offset + 2], binaryForm[offset + 3], binaryForm[offset + 5], binaryForm[offset + 6], binaryForm[offset + 4], binaryForm[offset + 7]});
        this.subAuthorities = new long[subAuthorityCount];
        for (i = 0; i < subAuthorityCount; i = (int)((byte)(i + 1))) {
            this.subAuthorities[i] = ((long)(binaryForm[offset + 8 + 4 * i + 0] & 0xFF) << 0) + ((long)(binaryForm[offset + 8 + 4 * i + 1] & 0xFF) << 8) + ((long)(binaryForm[offset + 8 + 4 * i + 2] & 0xFF) << 16) + ((long)(binaryForm[offset + 8 + 4 * i + 3] & 0xFF) << 24);
        }
        this.sddlForm = SecurityIdentifier.toSDDLForm(this.authority, this.subAuthorities);
    }

    public SecurityIdentifier(String sddlForm) {
        int i;
        Check.notNullOrEmpty(sddlForm, "sddlForm");
        this.sddlForm = sddlForm;
        String[] segments = sddlForm.split("-");
        Check.isTrue(segments.length >= 3, MessageFormat.format("The security identifier contains less than the minimum {0} segments", Integer.toString(3)));
        Check.isTrue(segments.length <= 18, MessageFormat.format("The security identifier string contains more than the maximum {0} segments", Integer.toString(18)));
        Check.isTrue("S".equals(segments[0]), "First security identifier segment must be 'S'");
        int revision = Integer.parseInt(segments[1]);
        SecurityIdentifier.checkRevision(revision);
        this.authority = SecurityIdentifier.parseAuthority(segments[2]);
        ArrayList<Long> subList = new ArrayList<Long>(15);
        for (i = 3; i < segments.length; ++i) {
            subList.add(SecurityIdentifier.parseSubAuthority(segments[i]));
        }
        this.subAuthorities = new long[subList.size()];
        for (i = 0; i < subList.size(); ++i) {
            this.subAuthorities[i] = (Long)subList.get(i);
        }
        this.binaryForm = SecurityIdentifier.toBinaryForm(this.authority, this.subAuthorities);
    }

    public SecurityIdentifier(long authority, long[] subAuthorities) {
        this.authority = new BigInteger(Long.toString(authority));
        this.subAuthorities = (long[])subAuthorities.clone();
        this.binaryForm = SecurityIdentifier.toBinaryForm(this.authority, subAuthorities);
        this.sddlForm = SecurityIdentifier.toSDDLForm(this.authority, subAuthorities);
    }

    private static BigInteger parseAuthority(String authority) {
        if (authority.startsWith("0x")) {
            Check.isTrue(authority.length() <= 14, "A hexadecimal authority must be at most 12 digits long");
            return new BigInteger(authority.substring(2), 16);
        }
        Check.isTrue(authority.length() <= 10, "A decimal authority must be at most 10 digits long");
        return new BigInteger(authority, 10);
    }

    private static long parseSubAuthority(String subAuthority) {
        long ret = Long.parseLong(subAuthority);
        Check.isTrue(ret <= 0x100000000L, MessageFormat.format("Subauthority value exceeds the maximum value of {0}", Long.toString(0x100000000L)));
        return ret;
    }

    public byte[] getBinaryForm() {
        return this.binaryForm;
    }

    public String getSDDLForm() {
        return this.sddlForm;
    }

    public String toString() {
        return this.sddlForm;
    }

    public String getValue() {
        return this.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SecurityIdentifier)) {
            return false;
        }
        return Arrays.equals(this.binaryForm, ((SecurityIdentifier)obj).binaryForm);
    }

    public int hashCode() {
        return Arrays.hashCode(this.binaryForm);
    }

    private static String toSDDLForm(BigInteger authority, long[] subAuthorities) {
        StringBuilder sb = new StringBuilder();
        sb.append("S-");
        sb.append(1);
        sb.append("-");
        int radix = 10;
        if (authority.compareTo(MAX_DECIMAL_AUTHORITY_VALUE) > 0) {
            radix = 16;
            sb.append("0x");
        }
        sb.append(authority.toString(radix));
        for (int i = 0; i < subAuthorities.length; ++i) {
            sb.append("-");
            sb.append(Long.toString(subAuthorities[i]));
        }
        return sb.toString();
    }

    private static byte[] toBinaryForm(BigInteger authority, long[] subAuthorities) {
        byte[] bytes = new byte[8 + 4 * subAuthorities.length];
        bytes[0] = 1;
        bytes[1] = (byte)subAuthorities.length;
        byte[] authorityBytes = authority.toByteArray();
        Check.isTrue(authorityBytes.length <= 6, "authorityBytes.length <= 6");
        System.arraycopy(authorityBytes, 0, bytes, 2, authorityBytes.length);
        for (int i = 0; i < subAuthorities.length; ++i) {
            for (int b = 0; b < 4; ++b) {
                bytes[8 + 4 * i + b] = (byte)(subAuthorities[i] >>> b * 8);
            }
        }
        return bytes;
    }

    private static void checkRevision(int revision) {
        Check.isTrue(revision == 1, MessageFormat.format("Unsupported revision {0}", Integer.toString(revision)));
    }

    private static void checkSubAuthorityCount(int subAuthorityCount) {
        Check.isTrue(subAuthorityCount <= 15, MessageFormat.format("The subauthority count {0} exceeds the maximum {1}", Integer.toString(subAuthorityCount), Integer.toString(15)));
    }
}

