/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.form;

import com.microsoft.tfs.core.clients.workitem.form.WIFormElement;
import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlExternalLinkFilters;
import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlWILinkFilters;
import com.microsoft.tfs.core.clients.workitem.form.WIFormLinksControlWITypeFilters;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormColumnImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormContentImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormControlImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormDescriptionImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormElementImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormGroupImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLabelTextImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLayoutImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinkColumnImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinkColumnsImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinkImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinksControlExternalLinkFilterImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinksControlExternalLinkFiltersImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinksControlOptionsImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinksControlWILinkFilterImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinksControlWILinkFiltersImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinksControlWITypeFilterImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormLinksControlWITypeFiltersImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormPaddingAttributeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormParamImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormSizeAttributeImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormSplitterImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormTabGroupImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormTabImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormTextImpl;
import com.microsoft.tfs.core.clients.workitem.internal.form.WIFormWebPageControlOptionsImpl;
import com.microsoft.tfs.util.xml.SAXUtils;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WIFormParseHandler
extends DefaultHandler {
    private static final Log log = LogFactory.getLog(WIFormParseHandler.class);
    private static HashMap elementNameMap = new HashMap();
    private final List elementStack = new ArrayList();
    private final Set handledElementNames = new HashSet();
    private WIFormElementImpl root;

    public static WIFormElement parse(String xml) {
        WIFormParseHandler handler = new WIFormParseHandler();
        try {
            SAXParser parser = SAXUtils.newSAXParser();
            parser.parse(new InputSource(new StringReader(xml)), (DefaultHandler)handler);
        }
        catch (SAXException ex) {
            ex.initCause(ex.getException());
            throw new RuntimeException(ex);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return handler.root;
    }

    private void push(WIFormElementImpl element) {
        this.elementStack.add(0, element);
    }

    private WIFormElementImpl pop() {
        return (WIFormElementImpl)this.elementStack.remove(0);
    }

    private WIFormElementImpl peek() {
        if (this.elementStack.size() > 0) {
            return (WIFormElementImpl)this.elementStack.get(0);
        }
        return null;
    }

    private WIFormElementImpl addChildElement(WIFormElementImpl element) {
        if (this.peek() != null) {
            this.peek().addChildElement(element);
        }
        return element;
    }

    public WIFormElementImpl getRoot() {
        return this.root;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String lowerElementName = qName.toLowerCase();
        this.handledElementNames.add(lowerElementName);
        if (elementNameMap.containsKey(lowerElementName)) {
            Constructor c = (Constructor)elementNameMap.get(lowerElementName);
            if (c != null) {
                try {
                    WIFormElementImpl impl = (WIFormElementImpl)c.newInstance(null);
                    impl.startLoading(attributes);
                    this.push(this.addChildElement(impl));
                    return;
                }
                catch (Exception e) {
                    log.warn((Object)MessageFormat.format("exception for element ({0}): {1}", qName, e.getMessage()));
                }
            }
        } else if (lowerElementName.equalsIgnoreCase("Filter")) {
            WIFormElementImpl parent = this.peek();
            WIFormElementImpl filter = null;
            if (parent instanceof WIFormLinksControlWITypeFilters) {
                filter = new WIFormLinksControlWITypeFilterImpl();
            } else if (parent instanceof WIFormLinksControlWILinkFilters) {
                filter = new WIFormLinksControlWILinkFilterImpl();
            } else if (parent instanceof WIFormLinksControlExternalLinkFilters) {
                filter = new WIFormLinksControlExternalLinkFilterImpl();
            }
            if (filter != null) {
                filter.startLoading(attributes);
                this.push(this.addChildElement(filter));
                return;
            }
        }
        this.handledElementNames.remove(lowerElementName);
        log.warn((Object)MessageFormat.format("unhandled element: {0}", qName));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String lowerElementName = qName.toLowerCase();
        if (this.handledElementNames.contains(lowerElementName)) {
            WIFormElementImpl x = this.pop();
            x.endLoading();
            if (this.elementStack.size() == 0) {
                this.root = x;
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        WIFormElementImpl element = this.peek();
        if (element != null) {
            if (element instanceof WIFormTextImpl) {
                WIFormTextImpl textElement = (WIFormTextImpl)element;
                textElement.appendInnerText(new String(buf, offset, len));
            } else if (element instanceof WIFormContentImpl) {
                WIFormContentImpl contentElement = (WIFormContentImpl)element;
                contentElement.setContent(new String(buf, offset, len));
            }
        }
    }

    public static Integer readIntegerValue(Attributes attributes, String attributeName) {
        String value = attributes.getValue(attributeName);
        if (value != null) {
            return new Integer(value);
        }
        return null;
    }

    public static WIFormSizeAttributeImpl readSizeAttribute(Attributes attributes, String attributeName) {
        String value = attributes.getValue(attributeName);
        if (value != null) {
            return new WIFormSizeAttributeImpl(value);
        }
        return null;
    }

    public static WIFormPaddingAttributeImpl readPaddingAttribute(Attributes attributes, String attributeName) {
        String value = attributes.getValue(attributeName);
        if (value != null) {
            return new WIFormPaddingAttributeImpl(value);
        }
        return null;
    }

    public static String readStringValue(Attributes attributes, String attributeName) {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.getQName(i);
            if (name == null || !name.equalsIgnoreCase(attributeName)) continue;
            return attributes.getValue(i);
        }
        return null;
    }

    public static boolean readBooleanValue(Attributes attributes, String attributeName, boolean defaultValue) {
        String value = attributes.getValue(attributeName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    static {
        Class[] emptyArgs = new Class[]{};
        try {
            elementNameMap.put("Form".toLowerCase(), WIFormDescriptionImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("Group".toLowerCase(), WIFormGroupImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("Control".toLowerCase(), WIFormControlImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("TabGroup".toLowerCase(), WIFormTabGroupImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("Splitter".toLowerCase(), WIFormSplitterImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("Layout".toLowerCase(), WIFormLayoutImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("Tab".toLowerCase(), WIFormTabImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("Column".toLowerCase(), WIFormColumnImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("LabelText".toLowerCase(), WIFormLabelTextImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("Link".toLowerCase(), WIFormLinkImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("Param".toLowerCase(), WIFormParamImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("Text".toLowerCase(), WIFormTextImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("LinkColumn".toLowerCase(), WIFormLinkColumnImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("LinksControlOptions".toLowerCase(), WIFormLinksControlOptionsImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("LinkColumns".toLowerCase(), WIFormLinkColumnsImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("WorkItemLinkFilters".toLowerCase(), WIFormLinksControlWILinkFiltersImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("WorkItemTypeFilters".toLowerCase(), WIFormLinksControlWITypeFiltersImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("ExternalLinkFilters".toLowerCase(), WIFormLinksControlExternalLinkFiltersImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("WebpageControlOptions".toLowerCase(), WIFormWebPageControlOptionsImpl.class.getConstructor(emptyArgs));
            elementNameMap.put("Content".toLowerCase(), WIFormContentImpl.class.getConstructor(emptyArgs));
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("Element constructor not found: {0}", e.getMessage()));
        }
    }
}

