/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.internal.query;

import com.microsoft.tfs.core.clients.workitem.exceptions.DeniedOrNotExistException;
import com.microsoft.tfs.core.clients.workitem.internal.WITContext;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryBucket;
import com.microsoft.tfs.core.clients.workitem.internal.query.StoredQueryImpl;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.GetStoredQueriesRowSetHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParseHandler;
import com.microsoft.tfs.core.clients.workitem.internal.rowset.RowSetParser;
import com.microsoft.tfs.core.clients.workitem.internal.update.DeleteStoredQueryUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.internal.update.InsertStoredQueryUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.internal.update.UpdateStoredQueryUpdatePackage;
import com.microsoft.tfs.core.clients.workitem.query.InvalidQueryTextException;
import com.microsoft.tfs.core.clients.workitem.query.StoredQuery;
import com.microsoft.tfs.core.exceptions.mappers.WorkItemExceptionMapper;
import com.microsoft.tfs.core.ws.runtime.types.DOMAnyContentType;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoredQueryProviderImpl {
    private static final Log log = LogFactory.getLog(StoredQueryProviderImpl.class);
    private final Map<Integer, StoredQueryBucket> buckets = new HashMap<Integer, StoredQueryBucket>();
    private final Map<GUID, StoredQuery> queryMap = new TreeMap<GUID, StoredQuery>();
    private final WITContext witContext;

    public StoredQueryProviderImpl(WITContext witContext) {
        this.witContext = witContext;
    }

    public void addStoredQuery(StoredQueryImpl storedQuery) throws InvalidQueryTextException {
        StoredQueryImpl.validateWIQL(this.witContext, storedQuery.getQueryText());
        this.sendInsert(storedQuery);
        StoredQueryBucket bucket = this.buckets.get(new Integer(storedQuery.getProjectID()));
        if (bucket != null) {
            bucket.add(storedQuery);
            Collections.sort(bucket.getQueryList());
        }
        if (!this.queryMap.containsKey(storedQuery.getQueryGUID())) {
            this.queryMap.put(storedQuery.getQueryGUID(), storedQuery);
        }
    }

    public void deleteStoredQuery(StoredQueryImpl storedQuery) {
        this.sendDelete(storedQuery);
        storedQuery.setDeleted(true);
        storedQuery.setQueryProvider(null);
        StoredQueryBucket bucket = this.buckets.get(new Integer(storedQuery.getProjectID()));
        if (bucket != null) {
            bucket.remove(storedQuery);
        }
        this.queryMap.remove(storedQuery.getQueryGUID());
    }

    public StoredQuery getQuery(GUID guid) {
        if (this.queryMap.containsKey(guid)) {
            return this.queryMap.get(guid);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("calling webservice GetStoredQuery({0})", guid));
        }
        DOMAnyContentType payload = null;
        try {
            payload = this.witContext.isVersion2() ? (DOMAnyContentType)this.witContext.getProxy().getStoredQuery(guid.getGUIDString(), new DOMAnyContentType()) : (this.witContext.isVersion3() ? (DOMAnyContentType)this.witContext.getProxy3().getStoredQuery(guid.getGUIDString(), new DOMAnyContentType()) : (DOMAnyContentType)this.witContext.getProxy5().getStoredQuery(guid.getGUIDString(), new DOMAnyContentType()));
        }
        catch (RuntimeException exception) {
            throw WorkItemExceptionMapper.map(exception);
        }
        RowSetParser parser = new RowSetParser();
        GetStoredQueriesRowSetHandler handler = new GetStoredQueriesRowSetHandler(this.witContext);
        parser.parse(payload.getElements()[0], (RowSetParseHandler)handler);
        if (handler.getQueries().length != 1) {
            throw new DeniedOrNotExistException();
        }
        StoredQueryImpl storedQuery = handler.getQueries()[0];
        this.queryMap.put(storedQuery.getQueryGUID(), storedQuery);
        return storedQuery;
    }

    public StoredQueryBucket getQueryBucket(int projectId) {
        Integer key = new Integer(projectId);
        if (this.buckets.containsKey(key)) {
            return this.buckets.get(key);
        }
        StoredQueryBucket bucket = new StoredQueryBucket(projectId, this.witContext);
        bucket.refresh();
        this.buckets.put(key, bucket);
        return bucket;
    }

    public void refresh(int projectId) {
        StoredQueryBucket bucket = this.buckets.get(new Integer(projectId));
        if (bucket != null) {
            bucket.refresh();
        }
    }

    private void sendDelete(StoredQueryImpl storedQuery) {
        DeleteStoredQueryUpdatePackage updatePackage = new DeleteStoredQueryUpdatePackage(storedQuery, this.witContext);
        updatePackage.update();
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("sent delete for: {0}", storedQuery.getQueryGUID()));
        }
    }

    private void sendInsert(StoredQueryImpl storedQuery) {
        InsertStoredQueryUpdatePackage updatePackage = new InsertStoredQueryUpdatePackage(storedQuery, this.witContext);
        updatePackage.update();
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("sent insert for: {0}", storedQuery.getQueryGUID()));
        }
    }

    private void sendUpdate(StoredQueryImpl storedQuery) {
        UpdateStoredQueryUpdatePackage updatePackage = new UpdateStoredQueryUpdatePackage(storedQuery, this.witContext);
        updatePackage.update();
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("sent update for: {0}", storedQuery.getQueryGUID()));
        }
    }

    public void updateStoredQuery(StoredQueryImpl storedQuery) {
        this.sendUpdate(storedQuery);
    }

    public Map<GUID, StoredQuery> getQueryMap() {
        return this.queryMap;
    }
}

