/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.clients.workitem.query.qe;

import com.microsoft.tfs.core.clients.workitem.query.qe.SortField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SortFieldCollection {
    private final List<SortField> list = new ArrayList<SortField>();
    private final Map<String, SortField> fieldNameToSortField = new HashMap<String, SortField>();

    public SortFieldCollection() {
    }

    public SortFieldCollection(SortFieldCollection sfc) {
        Iterator<SortField> it = sfc.iterator();
        while (it.hasNext()) {
            SortField sortField = it.next();
            this.add(new SortField(sortField.getFieldName(), sortField.isAscending()));
        }
    }

    public boolean contains(String fieldName) {
        return this.fieldNameToSortField.containsKey(fieldName);
    }

    public SortField[] toArray() {
        return this.list.toArray(new SortField[this.list.size()]);
    }

    public Iterator<SortField> iterator() {
        return this.list.iterator();
    }

    public void add(SortField item) {
        this.list.add(item);
        this.fieldNameToSortField.put(item.getFieldName(), item);
    }

    public void insert(int index, SortField item) {
        this.list.add(index, item);
        this.fieldNameToSortField.put(item.getFieldName(), item);
    }

    public void remove(SortField item) {
        this.list.remove(item);
        this.fieldNameToSortField.remove(item.getFieldName());
    }

    public void removeAt(int index) {
        SortField sortField = this.list.remove(index);
        this.fieldNameToSortField.remove(sortField.getFieldName());
    }

    public int indexOf(SortField item) {
        return this.list.indexOf(item);
    }

    public int getCount() {
        return this.list.size();
    }

    public SortField get(int index) {
        return this.list.get(index);
    }

    public void clear() {
        this.list.clear();
        this.fieldNameToSortField.clear();
    }
}

