/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.pguidance.internal;

import com.microsoft.tfs.core.Messages;
import com.microsoft.tfs.core.TFSTeamProjectCollection;
import com.microsoft.tfs.core.clients.commonstructure.ProjectInfo;
import com.microsoft.tfs.core.clients.framework.configuration.entities.ProcessGuidanceEntity;
import com.microsoft.tfs.core.clients.framework.configuration.entities.TeamProjectEntity;
import com.microsoft.tfs.core.httpclient.Header;
import com.microsoft.tfs.core.httpclient.HttpClient;
import com.microsoft.tfs.core.httpclient.methods.GetMethod;
import com.microsoft.tfs.core.pguidance.IProcessGuidance;
import com.microsoft.tfs.core.pguidance.ProcessGuidanceURLInfo;
import com.microsoft.tfs.core.pguidance.internal.ProcessGuidanceURLInfoImpl;
import com.microsoft.tfs.core.util.URIUtils;
import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.GUID;
import java.text.MessageFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSSProcessGuidance
implements IProcessGuidance {
    private static final String RESOLVE_PROCESS_GUIDANCE_URI_PROPERTY = "teamexplorer.resolveProcessGuidance";
    private static final Log log = LogFactory.getLog(WSSProcessGuidance.class);
    private final TFSTeamProjectCollection connection;
    private final boolean doResolve;

    public WSSProcessGuidance(TFSTeamProjectCollection connection) {
        this.connection = connection;
        this.doResolve = !"false".equals(System.getProperty(RESOLVE_PROCESS_GUIDANCE_URI_PROPERTY));
    }

    @Override
    public boolean isEnabled(ProjectInfo projectInfo) {
        ProcessGuidanceEntity processGuidance;
        Check.notNull(projectInfo, "projectInfo");
        TeamProjectEntity teamProject = this.connection.getTeamProjectCollectionEntity(false).getTeamProject(new GUID(projectInfo.getGUID()));
        ProcessGuidanceEntity processGuidanceEntity = processGuidance = teamProject == null ? null : teamProject.getProcessGuidance();
        return processGuidance != null;
    }

    @Override
    public ProcessGuidanceURLInfo getProcessGuidanceURL(ProjectInfo projectInfo, String documentPath) {
        return this.getProcessGuidanceURL(projectInfo, documentPath, null);
    }

    @Override
    public ProcessGuidanceURLInfo getProcessGuidanceURL(ProjectInfo projectInfo, String documentPath, String[] alternateDocumentPaths) {
        ProcessGuidanceEntity processGuidance;
        Check.notNull(projectInfo, "projectInfo");
        boolean valid = false;
        String invalidMessage = null;
        TeamProjectEntity teamProject = this.connection.getTeamProjectCollectionEntity(false).getTeamProject(new GUID(projectInfo.getGUID()));
        ProcessGuidanceEntity processGuidanceEntity = processGuidance = teamProject == null ? null : teamProject.getProcessGuidance();
        if (processGuidance == null) {
            return new ProcessGuidanceURLInfoImpl(null, false, MessageFormat.format(Messages.getString("WssProcessGuidance.ProcessGuidanceNotConfiguredFormat"), projectInfo.getName()));
        }
        String processGuidanceUrl = processGuidance.getFullyQualifiedURL();
        String url = URIUtils.combinePaths(processGuidanceUrl, documentPath);
        valid = this.isValidURL(url);
        if (!valid && alternateDocumentPaths != null) {
            int ix = 0;
            while (!valid && ix < alternateDocumentPaths.length) {
                url = URIUtils.combinePaths(processGuidanceUrl, alternateDocumentPaths[ix++]);
                valid = this.isValidURL(url);
            }
        }
        if (!valid && "WebSite".equals(processGuidance.getResourceSubType())) {
            url = processGuidanceUrl;
            valid = this.isValidURL(url);
        }
        if (!valid) {
            url = null;
            invalidMessage = MessageFormat.format(Messages.getString("WssProcessGuidance.ProcessGuidanceNotFoundFormat"), projectInfo.getName(), documentPath);
        }
        return new ProcessGuidanceURLInfoImpl(url, valid, invalidMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidURL(String url) {
        if (!this.doResolve) {
            return true;
        }
        String originalUrl = url;
        HttpClient httpClient = this.connection.newHTTPClient(URIUtils.newURI(url));
        GetMethod getMethod = new GetMethod(url);
        try {
            int code;
            for (int redirects = 0; redirects < 8; ++redirects) {
                code = httpClient.executeMethod(getMethod);
                if (code == 200) {
                    boolean bl = true;
                    return bl;
                }
                if (code == 301 || code == 302) {
                    Header[] responseHeaders = getMethod.getResponseHeaders("Location");
                    if (responseHeaders.length != 1) {
                        boolean bl = false;
                        return bl;
                    }
                    url = responseHeaders[0].getValue();
                    getMethod.releaseConnection();
                    httpClient = this.connection.newHTTPClient(URIUtils.newURI(url));
                    getMethod = new GetMethod(url);
                    continue;
                }
                log.info((Object)MessageFormat.format("Could not open process guidance page {0}: {1}", url, Integer.toString(code)));
                boolean bl = false;
                return bl;
            }
            log.warn((Object)MessageFormat.format("Too many redirects trying to open {0}", originalUrl));
            code = 0;
            return code != 0;
        }
        catch (Exception e) {
            log.warn((Object)MessageFormat.format("Error validating process guidance url: {0}", originalUrl), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            getMethod.releaseConnection();
        }
    }
}

