/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.core.ws.runtime.client;

import com.microsoft.tfs.core.httpclient.methods.RequestEntity;
import com.microsoft.tfs.core.ws.runtime.client.SOAPHeaderProvider;
import com.microsoft.tfs.core.ws.runtime.client.SOAPMethodRequestWriter;
import com.microsoft.tfs.core.ws.runtime.stax.StaxFactoryProvider;
import com.microsoft.tfs.util.Check;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLOutputFactory;

public abstract class SOAPRequestEntity
implements RequestEntity {
    public static final String SOAP_ENCODING = "utf-8";
    private static final XMLOutputFactory xmlOutputFactory = StaxFactoryProvider.getXMLOutputFactory();
    private final String methodName;
    private final String defaultNamespace;
    private final SOAPMethodRequestWriter requestWriter;
    private SOAPHeaderProvider soapHeaderProvider;

    public SOAPRequestEntity(String methodName, String defaultNamespace, SOAPMethodRequestWriter requestWriter) {
        Check.notNull(methodName, "methodName");
        Check.notNull(defaultNamespace, "defaultNamespace");
        Check.notNull(requestWriter, "requestWriter");
        this.methodName = methodName;
        this.defaultNamespace = defaultNamespace;
        this.requestWriter = requestWriter;
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        return xmlOutputFactory;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public SOAPMethodRequestWriter getRequestWriter() {
        return this.requestWriter;
    }

    public void setSOAPHeaderProvider(SOAPHeaderProvider soapHeaderProvider) {
        this.soapHeaderProvider = soapHeaderProvider;
    }

    public SOAPHeaderProvider getSoapHeaderProvider() {
        return this.soapHeaderProvider;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public abstract String getContentType();

    @Override
    public boolean isRepeatable() {
        return true;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public abstract void writeRequest(OutputStream var1) throws IOException;
}

