/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked;

import com.microsoft.tfs.jni.FileSystemUtils;
import com.microsoft.tfs.jni.Messages;
import com.microsoft.tfs.util.Check;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;

public class ResourceForkOutputStream
extends OutputStream {
    public static final String RESOURCEFORK_NAME = "com.apple.ResourceFork";
    private final String filename;
    private long position = 0L;

    public ResourceForkOutputStream(String filename) throws FileNotFoundException {
        Check.notNull(filename, "filename");
        if (!new File(filename).exists()) {
            throw new FileNotFoundException(MessageFormat.format(Messages.getString("ResourceForkOutputStream.DataForkForFileDoesNotExistFormat"), filename));
        }
        this.filename = filename;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        if (off == 0) {
            byte[] writebuf = buffer;
        } else {
            byte[] writebuf = new byte[len];
            System.arraycopy(buffer, len, writebuf, 0, len);
        }
        if (!FileSystemUtils.getInstance().writeMacExtendedAttribute(this.filename, RESOURCEFORK_NAME, buffer, len, this.position)) {
            throw new IOException("Could not write resource fork due to an internal error");
        }
        this.position += (long)len;
    }
}

