/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.jni.appleforked.fileformat.entry;

import com.microsoft.tfs.util.Check;
import java.text.MessageFormat;

public class AppleForkedMacFileInfoEntry {
    public static final int MAC_FILE_INFO_ENTRY_SIZE = 4;
    private boolean locked;
    private boolean protect;
    private static final int LOCKED_BIT = 1;
    private static final int PROTECTED_BIT = 2;

    public AppleForkedMacFileInfoEntry() {
    }

    public AppleForkedMacFileInfoEntry(byte[] macFileInfo) {
        this.decode(macFileInfo);
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public void setProtected(boolean protect) {
        this.protect = protect;
    }

    public void decode(byte[] macFileInfo) {
        Check.notNull(macFileInfo, "macFileInfo");
        Check.isTrue(macFileInfo.length >= 4, "macFileInfo.length >= MAC_FILE_INFO_ENTRY_SIZE");
        this.locked = (macFileInfo[3] & 1) == 1;
        this.protect = (macFileInfo[3] & 2) == 2;
    }

    public byte[] encode() {
        byte[] macFileInfo = new byte[4];
        macFileInfo[3] = (byte)(macFileInfo[3] ^ (this.locked ? (byte)1 : 0));
        macFileInfo[3] = (byte)(macFileInfo[3] ^ (this.protect ? 2 : 0));
        return macFileInfo;
    }

    public String toString() {
        return MessageFormat.format("protected={0}, locked={1}", this.protect ? "true" : "false", this.locked ? "true" : "false");
    }
}

