/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.ai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.ai.ILlmCompleter;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.IOption;
import com.teamscale.core.option.OptionFieldDescription;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public abstract class AiEngineProviderOptionBase
implements IOption {
    private static final long serialVersionUID = 1L;
    public static final String OPTION_ID_PREFIX = "ai-engine.";
    @JsonProperty(value="temperature")
    @OptionFieldDescription(name="A common parameter of large language models, which allows to control between determinism (temparature = 0) and creativity/randomness (temperature = 1). All values in between are also valid.")
    public double temperature = 0.1;

    public abstract String getInternalName();

    public abstract String getDisplayName();

    public abstract Optional<ILlmCompleter> createCompleter(@Nullable BiConsumer<String, Long> var1) throws ServiceCallException;

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        if (this.temperature < 0.0 || this.temperature > 1.0) {
            return "Parameter 'temperature' must be between 0 and 1 (inclusive)!";
        }
        return null;
    }

    @Override
    public void executedActionsAfterModification(IndexLayer indexLayer) {
        indexLayer.getMessageBroker().sendMessage("ai-options-changed", this.getInternalName());
    }

    @Override
    public void executedActionsBeforeDeletion(IndexLayer indexLayer, String optionId) {
        indexLayer.getMessageBroker().sendMessage("ai-options-changed", this.getInternalName());
    }
}

