/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.index.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public abstract class ConfigurableObjectBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String OPTIONS_PROPERTY = "options";
    @JsonProperty(value="options")
    private final @Nullable LinkedHashMap<String, String> options = new LinkedHashMap();

    protected ConfigurableObjectBase() {
    }

    protected ConfigurableObjectBase(@Nullable ConfigurableObjectBase configurableObject) {
        if (configurableObject != null && configurableObject.options != null) {
            this.options.putAll(configurableObject.options);
        }
    }

    public UnmodifiableSet<String> getOptionNames() {
        if (this.options == null) {
            return CollectionUtils.emptySet();
        }
        return CollectionUtils.asUnmodifiable(this.options.keySet());
    }

    public @Nullable String getOptionValue(String optionName) {
        if (this.options == null) {
            return null;
        }
        return this.options.get(optionName);
    }

    public void setOptionValue(String optionName, String optionValue) {
        this.options.put(optionName, optionValue);
    }

    public void removeOptions(Set<String> optionNames) {
        this.options.keySet().removeAll(optionNames);
    }

    public void removeOption(String optionName) {
        this.options.remove(optionName);
    }

    public @Nullable Map<String, String> getOptions() {
        return this.options;
    }

    public void sortOptionMap(List<ConfigOptionDescriptorBase> configOptionsInDesiredOrder) {
        List<String> keysInDesiredOrder = configOptionsInDesiredOrder.stream().map(ConfigurationItemBase::getName).toList();
        LinkedHashMap<String, String> orderedOptionsMap = new LinkedHashMap<String, String>();
        for (String key : keysInDesiredOrder) {
            orderedOptionsMap.put(key, this.options.get(key));
            this.options.remove(key);
        }
        this.options.putAll(orderedOptionsMap);
    }
}

