/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.ConfigurationBase;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.IConfigOptionDescriptorBehaviour;
import com.teamscale.core.analysis.configuration.model.option.WriteToFieldDescriptorBehaviour;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class ConfigOptionDescriptorBase
extends ConfigurationItemBase
implements WriteToFieldDescriptorBehaviour.IObjectInstanceRetriever {
    private static final long serialVersionUID = 1L;
    protected static final String DEFAULT_VALUE_PROPERTY = "defaultValue";
    protected static final String TYPE_PROPERTY = "type";
    protected static final String COLLECTION_TYPE_PROPERTY = "collectionType";
    protected static final String MULTILINE_TEXT_PROPERTY = "multilineText";
    protected static final String CHANGE_REQUIRES_RE_ANALYSIS_PROPERTY = "changeRequiresReAnalysis";
    protected static final String DEPENDENT_OPTIONS_PROPERTY = "dependentOptions";
    @JsonIgnore
    private final IConfigOptionDescriptorBehaviour behaviour;
    @JsonProperty(value="defaultValue")
    @Schema(implementation=OptionValue.class)
    protected @Nullable Object defaultValue;
    @JsonProperty(value="type")
    private final String type;
    @JsonProperty(value="collectionType")
    private final @Nullable String collectionType;
    @JsonProperty(value="multilineText")
    private final boolean multilineText;
    @JsonProperty(value="changeRequiresReAnalysis")
    private boolean changeRequiresReAnalysis;
    @JsonProperty(value="required")
    protected boolean required;
    @JsonProperty(value="dependentOptions")
    private String @Nullable [] dependentOptions;
    @JsonIgnore
    private final Class<? extends ConfigExposed.IOptionValueValidator> validatorClass;

    protected ConfigOptionDescriptorBase(ConfigExposed annotation, Field field) {
        this(annotation, field, null);
    }

    protected ConfigOptionDescriptorBase(ConfigExposed annotation, Field field, String collectionType) {
        this(annotation.name(), annotation.description(), annotation.validator(), annotation.visibility(), annotation.multilineText(), annotation.changeRequiresReAnalysis(), annotation.required(), field, collectionType, annotation.dependentOptions());
    }

    protected ConfigOptionDescriptorBase(String name, String description, Class<? extends ConfigExposed.IOptionValueValidator> validatorClass, ConfigExposed.EConfigVisibility visibility, boolean multilineText, boolean changeRequiresReAnalysis, boolean required, Field field) {
        this(name, description, validatorClass, visibility, multilineText, changeRequiresReAnalysis, required, field, null, new String[0]);
    }

    protected ConfigOptionDescriptorBase(String name, String description, Class<? extends ConfigExposed.IOptionValueValidator> validatorClass, ConfigExposed.EConfigVisibility visibility, boolean multilineText, boolean changeRequiresReAnalysis, boolean required, Field field, @Nullable String collectionType, String @Nullable [] dependentOptions) {
        super(name, description, visibility);
        this.validatorClass = validatorClass;
        this.behaviour = new WriteToFieldDescriptorBehaviour(field, this);
        this.type = this.behaviour.getTypeName();
        this.collectionType = collectionType;
        this.multilineText = multilineText;
        this.changeRequiresReAnalysis = changeRequiresReAnalysis;
        this.dependentOptions = dependentOptions;
        this.required = required;
    }

    protected ConfigOptionDescriptorBase(String name, String description, boolean multilineText, IConfigOptionDescriptorBehaviour behaviour) {
        super(name, description, ConfigExposed.EConfigVisibility.DEFAULT);
        this.validatorClass = ConfigExposed.IOptionValueValidator.class;
        this.behaviour = behaviour;
        this.type = behaviour.getTypeName();
        this.collectionType = null;
        this.multilineText = multilineText;
    }

    protected ConfigOptionDescriptorBase(String name, String description) {
        super(name, description, ConfigExposed.EConfigVisibility.DEFAULT);
        this.validatorClass = ConfigExposed.IOptionValueValidator.class;
        this.behaviour = null;
        this.type = null;
        this.collectionType = null;
        this.multilineText = false;
    }

    @Override
    public ConfigurationBase getObjectInstance() {
        return this.getConfiguration();
    }

    @Override
    protected void setConfiguration(ConfigurationBase configuration) {
        super.setConfiguration(configuration);
        this.defaultValue = this.retrieveDefaultValue();
    }

    public Object retrieveValue(CodeScopeName codeScopeName) {
        return this.behaviour.retrieveValue(codeScopeName);
    }

    public Object retrieveDefaultValue() {
        return this.behaviour.retrieveDefaultValue();
    }

    public @Nullable String retrieveValueAsString(CodeScopeName codeScopeName) {
        Object value = this.retrieveValue(codeScopeName);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public String getType() {
        return this.type;
    }

    public @Nullable Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultValueAsString() {
        if (this.defaultValue == null) {
            return null;
        }
        return String.valueOf(this.defaultValue);
    }

    public boolean isMultilineText() {
        return this.multilineText;
    }

    @Override
    public boolean requiredToolPresent(Set<EAnalysisTool> tools) {
        return true;
    }

    @Override
    public void setValue(String optionValue, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        this.validateValue(optionValue);
        if (optionValue == null) {
            this.storeValue(this.retrieveDefaultValue(), codeScopeName);
        } else {
            this.storeValue(this.parseValue(optionValue), codeScopeName);
        }
    }

    @Override
    public String toString() {
        return String.format("%s : '%s'", this.getName(), this.retrieveValues());
    }

    private @NonNull UnmodifiableList<?> retrieveValues() {
        return this.behaviour.retrieveValues();
    }

    protected void storeValue(Object value, CodeScopeName codeScopeName) throws AssertionError {
        this.behaviour.storeValue(value, codeScopeName);
    }

    void validateValue(String optionValue) throws ProjectConfigurationException {
        if (this.validatorClass == null || this.validatorClass.isInterface()) {
            return;
        }
        try {
            this.validatorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).validate(optionValue);
        }
        catch (ReflectiveOperationException e) {
            CCSMAssert.fail((String)("Could not create validator class " + String.valueOf(this.validatorClass) + ": " + e.getMessage()));
        }
    }

    public void setValueAndDefaultValue(String optionValue, CodeScopeName codeScopeName) throws ProjectConfigurationException {
        this.setValue(optionValue, codeScopeName);
        this.defaultValue = this.retrieveValue(codeScopeName);
    }

    protected abstract Object parseValue(String var1) throws ProjectConfigurationException;

    public static Comparator<ConfigOptionDescriptorBase> getByVisibilityComparator() {
        return Comparator.comparing(ConfigurationItemBase::getVisibility);
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Schema(oneOf={Number.class, String.class, Boolean.class, Object.class})
    public static interface OptionValue {
    }
}

