/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.crowd;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.NamedServer;
import com.teamscale.core.authenticate.crowd.CrowdAuthenticator;
import com.teamscale.core.authenticate.crowd.CrowdServerDescription;
import com.teamscale.core.authenticate.crowd.client.CrowdGroup;
import com.teamscale.core.authenticate.crowd.client.CrowdUser;
import com.teamscale.core.authenticate.crowd.client.ICrowdClient;
import com.teamscale.core.authenticate.crowd.client.ICrowdNamedEntity;
import com.teamscale.core.authenticate.crowd.client.ICrowdSearchRestriction;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroup;
import com.teamscale.core.user.UserIndex;
import com.teamscale.core.user.UserUtils;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CrowdUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CROWD_USER_EXTERNAL_ID = "crowd.user.external-id.field";
    private static final ICrowdSearchRestriction.PropertyCrowdSearchRestriction.Property<String> NAME_PROPERTY = new ICrowdSearchRestriction.PropertyCrowdSearchRestriction.Property<String>("name", String.class);

    public static String testConnection(CrowdServerDescription serverDescription) {
        ICrowdClient client = CrowdUtils.createClient(serverDescription);
        try {
            client.search(ICrowdClient.EEntityType.USER, new ICrowdSearchRestriction.PropertyCrowdSearchRestriction<Object>(NAME_PROPERTY, ICrowdSearchRestriction.PropertyCrowdSearchRestriction.EMatchMode.NULL, null), 0, 1);
            return null;
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == Response.Status.UNAUTHORIZED.getStatusCode()) {
                return "Authentication at Crowd server failed";
            }
            return "Cannot connect to Crowd server: " + e.getMessage();
        }
    }

    public static void authenticateUser(User user, String password, CrowdServerDescription serverDescription) throws AuthenticationToolException {
        ICrowdClient client = CrowdUtils.createClient(serverDescription);
        try {
            client.authenticateUser(user.getUsername(), new ICrowdClient.PasswordBody(password));
        }
        catch (ServiceCallException e) {
            throw new AuthenticationToolException("Authentication failed!", e);
        }
    }

    public static Optional<User> updateOrImportUser(String username, NamedServer<CrowdServerDescription> server, UserIndex userIndex, IMessageBroker messageBroker) throws StorageException, AuthenticationToolException {
        Optional<User> user = CrowdUtils.findUser(username, server);
        if (user.isPresent()) {
            UserUtils.updateUserInIndex(userIndex, user.get(), null, messageBroker);
        }
        return user;
    }

    private static Optional<User> findUser(String username, NamedServer<CrowdServerDescription> server) throws AuthenticationToolException {
        ICrowdClient client = CrowdUtils.createClient(server.serverDescription());
        try {
            CrowdUser crowdUser = client.getUser(username);
            if (crowdUser == null) {
                return Optional.empty();
            }
            String authenticator = AuthenticationToolUtils.buildAuthenticator(CrowdAuthenticator.IDENTIFIER, server.name());
            User user = new User(crowdUser.username(), crowdUser.firstName(), crowdUser.lastName(), crowdUser.email(), authenticator);
            HashMap<String, String> details = user.getAdditionalDetailsMap();
            details.put(CROWD_USER_EXTERNAL_ID, crowdUser.externalId());
            return Optional.of(user);
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                return Optional.empty();
            }
            throw new AuthenticationToolException("Fetching user failed!", e);
        }
    }

    public static UserGroup findGroup(String groupName, NamedServer<CrowdServerDescription> server) throws AuthenticationToolException {
        ICrowdClient client = CrowdUtils.createClient(server.serverDescription());
        try {
            CrowdGroup crowdGroup = (CrowdGroup)Retrofit.executeServiceCall(client.getGroup(groupName)).orElseThrow(() -> new AuthenticationEntityNotFoundException("Group '" + groupName + "' was not found!"));
            return new UserGroup(groupName, EAuthenticationTool.CROWD, crowdGroup.name(), server.name());
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new AuthenticationEntityNotFoundException("Group '" + groupName + "' was not found!", e);
            }
            throw new AuthenticationToolException("Fetching group failed!", e);
        }
    }

    public static List<String> getNestedUsersInGroup(CrowdServerDescription serverDescription, UserGroup group) throws AuthenticationToolException {
        ICrowdClient client = CrowdUtils.createClient(serverDescription);
        String groupName = group.getName();
        try {
            ICrowdClient.GetNestedUsersResponse response = client.getNestedUsersOfGroup(groupName, 0, Integer.MAX_VALUE);
            if (response == null) {
                throw new AuthenticationEntityNotFoundException("Group '" + groupName + "' was not found!");
            }
            return CollectionUtils.map(response.nestedUsers(), CrowdUser::username);
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new AuthenticationEntityNotFoundException("Group '" + groupName + "' was not found!", e);
            }
            throw new AuthenticationToolException("Fetching users from group '" + groupName + "' failed!", e);
        }
    }

    public static Set<String> getNestedGroupsOfUser(CrowdServerDescription serverDescription, User user) throws AuthenticationToolException {
        ICrowdClient client = CrowdUtils.createClient(serverDescription);
        String username = user.getUsername();
        try {
            ICrowdClient.GetNestedGroupsResponse response = client.getNestedGroupsOfUser(username, 0, Integer.MAX_VALUE);
            if (response == null) {
                throw new AuthenticationEntityNotFoundException("User '" + username + "' was not found!");
            }
            return response.nestedGroups().stream().map(CrowdGroup::name).collect(Collectors.toSet());
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new AuthenticationEntityNotFoundException("User '" + username + "' was not found!", e);
            }
            throw new AuthenticationToolException("Fetching groups for user '" + username + "' failed!", e);
        }
    }

    public static boolean groupExists(CrowdServerDescription serverDescription, String groupName) throws AuthenticationToolException {
        ICrowdClient client = CrowdUtils.createClient(serverDescription);
        try {
            return Retrofit.executeServiceCall(client.getGroup(groupName)).isPresent();
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == Response.Status.NOT_FOUND.getStatusCode()) {
                return false;
            }
            throw new AuthenticationToolException("Fetching group failed!", e);
        }
    }

    public static List<String> listUserNamesWithPrefix(NamedServer<CrowdServerDescription> server, String prefix, int limit) throws AuthenticationToolException {
        return CrowdUtils.listEntityNamesWithPrefix(server, ICrowdClient.EEntityType.USER, prefix, limit);
    }

    private static List<String> listEntityNamesWithPrefix(NamedServer<CrowdServerDescription> server, ICrowdClient.EEntityType entityType, String prefix, int limit) throws AuthenticationToolException {
        ICrowdClient client = CrowdUtils.createClient(server.serverDescription());
        ICrowdSearchRestriction.PropertyCrowdSearchRestriction<String> filter = new ICrowdSearchRestriction.PropertyCrowdSearchRestriction<String>(NAME_PROPERTY, ICrowdSearchRestriction.PropertyCrowdSearchRestriction.EMatchMode.STARTS_WITH, prefix);
        try {
            return client.search(entityType, filter, 0, limit).getResults().stream().map(ICrowdNamedEntity::getName).toList();
        }
        catch (ServiceCallException e) {
            throw new AuthenticationToolException("Fetching " + entityType.name() + " suggestions failed!", e);
        }
    }

    public static List<String> listGroupNamesWithPrefix(NamedServer<CrowdServerDescription> server, String prefix, int limit) throws AuthenticationToolException {
        return CrowdUtils.listEntityNamesWithPrefix(server, ICrowdClient.EEntityType.GROUP, prefix, limit);
    }

    private static ICrowdClient createClient(CrowdServerDescription serverDescription) {
        return (ICrowdClient)Retrofit.builder((String)serverDescription.url).withInteractionLogger(LOGGER).withBasicNTLMAuthentication(serverDescription.applicationName, serverDescription.applicationPassword).create(ICrowdClient.class);
    }

    private CrowdUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

