/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.monitoring;

import com.teamscale.core.option.HashedPasswordOptionUtils;
import com.teamscale.core.options.PrometheusServiceOption;
import com.teamscale.core.permissions.DefaultGlobalRoles;
import com.teamscale.core.permissions.ESubjectType;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.PermissionUtils;
import com.teamscale.core.user.User;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.Strings;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

public class PrometheusAuthenticationHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Pattern PROMETHEUS_ENDPOINT_PATTERN = Pattern.compile("^api(?:/v[0-9]+\\.[0-9]+\\.[0-9]+)?/monitoring/prometheus$");
    public static final String PROMETHEUS_MONITORING_INTERNAL_TEAMSCALE_USER_NAME = "prometheus-monitoring-internal-teamscale-user";

    public static boolean isPrometheusRequest(ContainerRequestContext requestContext) {
        return PROMETHEUS_ENDPOINT_PATTERN.matcher(requestContext.getUriInfo().getPath()).matches();
    }

    public static @Nullable User authenticate(PermissionIndex permissionIndex, @Nullable String authHeader, ContainerRequestContext requestContext, PrometheusServiceOption option) throws StorageException {
        String[] authMethods;
        if (!option.enableService) {
            return null;
        }
        String hashedPasswordAndSalt = option.secret;
        if (StringUtils.isEmpty((String)hashedPasswordAndSalt)) {
            return PrometheusAuthenticationHelper.createTemporaryPrometheusUser(permissionIndex);
        }
        String token = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"token");
        if (token != null && HashedPasswordOptionUtils.isPasswordCorrectForOption(hashedPasswordAndSalt, Strings.toUTF8ByteArray((String)token))) {
            LOGGER.warn("Authentication via query parameter has been deprecated for the prometheus service. Migrate to Bearer Authentication via HTTP Headers.");
            return PrometheusAuthenticationHelper.createTemporaryPrometheusUser(permissionIndex);
        }
        if (authHeader == null) {
            return null;
        }
        for (String authMethod : authMethods = authHeader.split(",")) {
            String password;
            if (!authMethod.startsWith("Bearer ") || !HashedPasswordOptionUtils.isPasswordCorrectForOption(hashedPasswordAndSalt, Strings.toUTF8ByteArray((String)(password = authMethod.substring("Bearer ".length()))))) continue;
            return PrometheusAuthenticationHelper.createTemporaryPrometheusUser(permissionIndex);
        }
        return null;
    }

    private static User createTemporaryPrometheusUser(PermissionIndex permissionIndex) throws StorageException {
        User user = new User(PROMETHEUS_MONITORING_INTERNAL_TEAMSCALE_USER_NAME, "", "", "", "DenyAll");
        Set<String> roles = permissionIndex.getGlobalRoles(ESubjectType.USER, PROMETHEUS_MONITORING_INTERNAL_TEAMSCALE_USER_NAME);
        if (!roles.contains(DefaultGlobalRoles.MONITORING.getReadableName())) {
            PermissionUtils.assignGlobalRole(permissionIndex, user, DefaultGlobalRoles.MONITORING);
        }
        return user;
    }
}

