/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.index;

import com.google.common.base.Preconditions;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.IndexWithCache;
import org.conqat.engine.persistence.cache.StorageCacheBase;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="projects")
@IndexWithCache(value={ProjectInfoCache.class})
public class ProjectIndex
implements IGlobalIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String INDEX_NAME = "projects";
    private final SynchronizedCacheAccess<ProjectInfoCache> projectInfoCacheAccess;
    private final ValueIndex<ProjectInfo> delegate;

    public ProjectIndex(IStore store, SynchronizedCacheAccess<ProjectInfoCache> projectInfoCacheAccess) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
        this.projectInfoCacheAccess = projectInfoCacheAccess;
    }

    private ProjectInfo findProjectForPublicId(PublicProjectId projectId) throws StorageException {
        return (ProjectInfo)this.projectInfoCacheAccess.getOrUpdate(projectInfoCache -> projectInfoCache.findProjectForId((IProjectId)projectId, this));
    }

    public void setProject(ProjectInfo newInfo) throws StorageException {
        Preconditions.checkNotNull((Object)newInfo);
        Preconditions.checkNotNull((Object)newInfo.getInternalId());
        List<ProjectInfo> allProjectInfos = this.getAllProjectInfos();
        for (ProjectInfo existingInfo : allProjectInfos) {
            if (existingInfo.getInternalId().equals((Object)newInfo.getInternalId())) continue;
            HashSet sharedProjectIds = CollectionUtils.intersectionSet((Collection)existingInfo.getPublicIds(), (Collection[])new Collection[]{newInfo.getPublicIds()});
            if (sharedProjectIds.isEmpty()) continue;
            throw new StorageException("Cannot save project " + String.valueOf(newInfo.getPrimaryPublicId()) + " (" + String.valueOf(newInfo.getInternalId()) + "), as it uses the same public ID(s) as project " + String.valueOf(existingInfo.getPrimaryPublicId()) + " (" + String.valueOf(existingInfo.getInternalId()) + "). Shared public IDs: [" + StringUtils.concat((Iterable)sharedProjectIds, (String)", ") + "]");
        }
        this.delegate.setValue(newInfo.getInternalId().toString(), (Object)newInfo);
        this.projectInfoCacheAccess.invalidate("Project updated: " + String.valueOf(newInfo.getInternalId()));
    }

    public void removeProject(InternalProjectId projectId) throws StorageException {
        this.delegate.removeValue(projectId.toString());
        this.projectInfoCacheAccess.invalidate("Project removed: " + String.valueOf(projectId));
    }

    public void removeAllProjects() throws StorageException {
        this.delegate.removeAllEntries();
        this.projectInfoCacheAccess.invalidate("all projects removed");
    }

    public List<ProjectInfo> resolveProjects(List<PublicProjectId> projectIds) throws StorageException {
        return CollectionUtils.mapWithException(projectIds, this::resolveProject);
    }

    public Optional<ProjectInfo> getProjectWithoutPublicIdResolution(InternalProjectId internalProjectId) throws StorageException {
        return Optional.ofNullable((ProjectInfo)this.delegate.getValue(internalProjectId.toString()));
    }

    public ProjectInfo resolveProject(IProjectId projectId) throws StorageException {
        Optional<ProjectInfo> projectInfo = this.tryResolveProject(projectId);
        if (projectInfo.isPresent()) {
            return projectInfo.get();
        }
        throw new StorageException("Project " + String.valueOf(projectId) + " cannot be resolved");
    }

    public Optional<ProjectInfo> tryResolveProject(IProjectId projectId) throws StorageException {
        if (projectId.equals((Object)SchedulingConstants.MAINTENANCE_PROJECT_PUBLIC_ID) || projectId.equals((Object)SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID)) {
            return Optional.of(SchedulingConstants.MAINTENANCE_PROJECT_INFO);
        }
        ProjectInfo projectInfo = projectId.isInternal() ? (ProjectInfo)this.delegate.getValue(projectId.toString()) : this.findProjectForPublicId((PublicProjectId)projectId);
        return Optional.ofNullable(projectInfo);
    }

    public InternalProjectId resolveToInternalId(IProjectId projectId) throws StorageException {
        Optional<InternalProjectId> internalProjectId = this.tryResolveToInternalId(projectId);
        if (internalProjectId.isPresent()) {
            return internalProjectId.get();
        }
        throw new StorageException("Project " + String.valueOf(projectId) + " cannot be resolved");
    }

    public Optional<InternalProjectId> tryResolveToInternalId(IProjectId projectId) throws StorageException {
        CCSMAssert.isNotNull((Object)projectId);
        if (projectId.isInternal()) {
            return Optional.of((InternalProjectId)projectId);
        }
        if (projectId.equals((Object)SchedulingConstants.MAINTENANCE_PROJECT_PUBLIC_ID)) {
            return Optional.of(SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID);
        }
        ProjectInfo project = this.findProjectForPublicId((PublicProjectId)projectId);
        if (project != null) {
            return Optional.of(project.getInternalId());
        }
        return Optional.empty();
    }

    public Set<InternalProjectId> getRelatedInternalProjectIds(InternalProjectId internalId) throws StorageException {
        HashSet<InternalProjectId> relatedProjectIds = new HashSet<InternalProjectId>();
        Optional<ProjectInfo> projectInfo = this.getProjectWithoutPublicIdResolution(internalId);
        if (projectInfo.isEmpty()) {
            LOGGER.error("Requested related projects for non-existing project ID " + String.valueOf(internalId) + ". Falling back to no related projects.");
            return relatedProjectIds;
        }
        Optional parentProjectId = projectInfo.get().getParentProjectId();
        InternalProjectId potentialParentProjectId = parentProjectId.orElseGet(() -> ((ProjectInfo)projectInfo.get()).getInternalId());
        relatedProjectIds.add(potentialParentProjectId);
        relatedProjectIds.addAll(this.getChildProjects(potentialParentProjectId));
        return relatedProjectIds;
    }

    private List<InternalProjectId> getChildProjects(InternalProjectId parentProjectId) throws StorageException {
        ArrayList<InternalProjectId> childProjectIds = new ArrayList<InternalProjectId>();
        for (ProjectInfo projectInfo : this.getAllProjectInfos()) {
            if (!projectInfo.getParentProjectId().isPresent() || !((InternalProjectId)projectInfo.getParentProjectId().get()).equals((Object)parentProjectId)) continue;
            childProjectIds.add(projectInfo.getInternalId());
        }
        return childProjectIds;
    }

    public List<ProjectInfo> getAllProjectInfos() throws StorageException {
        return (List)this.projectInfoCacheAccess.getOrUpdate(projectInfoCache -> projectInfoCache.getAllProjectInfos(this));
    }

    public List<InternalProjectId> getAllInternalProjectIds() throws StorageException {
        return CollectionUtils.map(this.getAllProjectInfos(), ProjectInfo::getInternalId);
    }

    public List<PublicProjectId> getAllPrimaryPublicProjectIds() throws StorageException {
        return CollectionUtils.map(this.getAllProjectInfos(), ProjectInfo::getPrimaryPublicId);
    }

    private PairList<String, ProjectInfo> getAllEntriesInternal() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public String findProjectName(IProjectId projectId) throws StorageException {
        Optional<ProjectInfo> projectInfo = this.tryResolveProject(projectId);
        if (projectInfo.isPresent() && projectInfo.get().getName() != null) {
            return projectInfo.get().getName();
        }
        return projectId.toString();
    }

    public Set<PublicProjectId> resolvePatterns(List<String> crossAnnotationProjects) throws StorageException {
        HashSet<PublicProjectId> matchingProjectIds = new HashSet<PublicProjectId>();
        List allProjectInfos = this.getAllEntriesInternal().extractSecondList();
        List projectPatterns = CollectionUtils.map(crossAnnotationProjects, projectAntString -> AntPatternUtils.convertPattern((String)projectAntString, (boolean)true));
        for (Pattern projectIdPattern : projectPatterns) {
            matchingProjectIds.addAll(CollectionUtils.filterAndMap((Collection)allProjectInfos, projectInfo -> ProjectIndex.matchesPublicId(projectInfo, projectIdPattern), ProjectInfo::getPrimaryPublicId));
        }
        return matchingProjectIds;
    }

    private static boolean matchesPublicId(ProjectInfo projectInfo, Pattern publicIdPattern) {
        return projectInfo.getPublicIds().stream().anyMatch(projectKey -> publicIdPattern.matcher(projectKey.toString()).matches());
    }

    public static class ProjectInfoCache
    extends StorageCacheBase {
        private Map<IProjectId, ProjectInfo> projectInfosByPublicId = null;
        private List<ProjectInfo> allProjectInfos = null;

        private ProjectInfo findProjectForId(IProjectId projectId, ProjectIndex projectIndex) throws StorageException {
            this.ensureCacheIsValid(projectIndex);
            return this.projectInfosByPublicId.get(projectId);
        }

        private List<ProjectInfo> getAllProjectInfos(ProjectIndex projectIndex) throws StorageException {
            this.ensureCacheIsValid(projectIndex);
            return this.allProjectInfos;
        }

        public synchronized void invalidateThreadSafe() {
            this.projectInfosByPublicId = null;
            this.allProjectInfos = null;
        }

        private void ensureCacheIsValid(ProjectIndex projectIndex) throws StorageException {
            if (this.projectInfosByPublicId != null && this.allProjectInfos != null) {
                return;
            }
            this.projectInfosByPublicId = new HashMap<IProjectId, ProjectInfo>();
            this.allProjectInfos = CollectionUtils.sort((Collection)projectIndex.getAllEntriesInternal().extractSecondList());
            for (ProjectInfo project : this.allProjectInfos) {
                UnmodifiableList publicIds = project.getPublicIds();
                if (project.isDeleting()) continue;
                for (PublicProjectId publicId : publicIds) {
                    this.projectInfosByPublicId.put((IProjectId)publicId, project);
                }
            }
        }
    }
}

