/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.profiler;

import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.profiler.DetailedProfilerLog;
import com.teamscale.core.log.profiler.ShortProfilerLog;
import java.util.Collection;
import java.util.Stack;
import java.util.UUID;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.jetbrains.annotations.VisibleForTesting;

@Index(name="coverage-profiler-log-index", options={EStorageOption.COMPRESSED})
public class GlobalProfilerLogIndex
extends LogIndexBase<ShortProfilerLog, DetailedProfilerLog>
implements IGlobalIndex {
    static final String INDEX_NAME = "coverage-profiler-log-index";
    private static final int LOGS_TO_KEEP_PER_RUN = 200;
    private final Stack<UUID> profilerIdStack = new Stack();

    public GlobalProfilerLogIndex(IStore store) {
        super((IStore)new DelegatingPartitionStore(store));
    }

    public void setProfiler(UUID profilerId) {
        this.profilerIdStack.clear();
        this.pushProfilerId(profilerId);
    }

    private void pushProfilerId(UUID profilerId) {
        ((DelegatingPartitionStore)this.store.getWrappedStore()).setPartition(profilerId.toString());
        this.profilerIdStack.push(profilerId);
    }

    private void popProfilerId() {
        this.profilerIdStack.pop();
        if (!this.profilerIdStack.isEmpty()) {
            ((DelegatingPartitionStore)this.store.getWrappedStore()).setPartition(this.profilerIdStack.peek().toString());
        }
    }

    @VisibleForTesting
    public void purgeOldLogs(Collection<UUID> cutLogsFor, Collection<UUID> purgeCompletelyFor, int numOfLogEntriesToKeep) throws StorageException {
        for (UUID profilerId : purgeCompletelyFor) {
            this.purgeProfilersLogs(profilerId, 0);
        }
        for (UUID profilerId : cutLogsFor) {
            this.purgeProfilersLogs(profilerId, numOfLogEntriesToKeep);
        }
    }

    public void purgeOldLogs(Collection<UUID> cutLogsFor, Collection<UUID> purgeCompletelyFor) throws StorageException {
        this.purgeOldLogs(cutLogsFor, purgeCompletelyFor, 200);
    }

    private void purgeProfilersLogs(UUID profilerId, int retain) throws StorageException {
        this.pushProfilerId(profilerId);
        try {
            this.purge(retain);
        }
        finally {
            this.popProfilerId();
        }
    }
}

