/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.option;

import com.teamscale.core.option.IOption;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

public abstract class OptionIndexBase {
    private final ValueIndex<IOption> delegate;

    protected OptionIndexBase(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void setOption(String optionKey, IOption optionValue) throws StorageException {
        this.delegate.setValue(optionKey, (Object)optionValue);
    }

    public PairList<String, IOption> getOptionsStartingWith(String optionKeyPrefix) throws StorageException {
        return this.delegate.getEntriesStartingWith(optionKeyPrefix);
    }

    public @Nullable IOption getOption(String optionKey) throws StorageException {
        return (IOption)this.delegate.getValue(optionKey);
    }

    public void removeOption(String optionKey) throws StorageException {
        this.delegate.removeValue(optionKey);
    }

    public void removeOptions(List<String> optionKeysToDelete) throws StorageException {
        this.delegate.removeValues(optionKeysToDelete);
    }

    public List<String> getAllOptionKeys() throws StorageException {
        return this.delegate.getAllKeys();
    }

    public void setOptions(PairList<String, IOption> optionKeyAndValues) throws StorageException {
        this.delegate.setValues(optionKeyAndValues);
    }
}

