/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.api.progress;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class AnalysisState
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TIMESTAMP_PROPERTY_NAME = "timestamp";
    private static final String ROLLBACK_ID_PROPERTY_NAME = "rollbackId";
    private static final String STATE_PROPERTY_NAME = "state";
    @JsonProperty(value="timestamp")
    private final Long timestamp;
    @JsonProperty(value="state")
    private final EAnalysisState state;
    @JsonProperty(value="rollbackId")
    private final @Nullable String rollbackId;

    public AnalysisState(@JsonProperty(value="timestamp") Long timestamp, @JsonProperty(value="state") EAnalysisState state, @JsonProperty(value="rollbackId") @Nullable UUID rollbackId) {
        this.timestamp = timestamp;
        this.state = state;
        this.rollbackId = Optional.ofNullable(rollbackId).map(UUID::toString).orElse(null);
    }

    public EAnalysisState getState() {
        return this.state;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public UUID getRollbackId() {
        if (this.rollbackId == null) {
            return null;
        }
        return UUID.fromString(this.rollbackId);
    }

    public String toString() {
        return this.state.name() + " " + this.getTimestamp();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalysisState that = (AnalysisState)o;
        return Objects.equals(this.timestamp, that.timestamp) && this.state == that.state;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.timestamp, this.state});
    }
}

