/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.analysis;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.findings.metrics.BlacklistCountMetric;
import com.teamscale.core.runtime.impl.analysis.CoreConfiguration;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class FlaggedFindingsConfiguration
extends AnalysisConfigurationBase {
    private static final String ADDITIONAL_FINDING_METRICS_ANALYSIS_GROUP_NAME = "Additional Finding Metrics";
    private final List<MetricHolder> metrics = Arrays.asList(new MetricHolder(BlacklistCountMetric.COMPLETE, true), new MetricHolder(BlacklistCountMetric.COMPLETE_RED), new MetricHolder(BlacklistCountMetric.COMPLETE_YELLOW), new MetricHolder(BlacklistCountMetric.TOLERATED), new MetricHolder(BlacklistCountMetric.TOLERATED_RED, true), new MetricHolder(BlacklistCountMetric.TOLERATED_YELLOW), new MetricHolder(BlacklistCountMetric.FALSE_POSITIVE), new MetricHolder(BlacklistCountMetric.FALSE_POSITIVE_RED), new MetricHolder(BlacklistCountMetric.FALSE_POSITIVE_YELLOW));

    public FlaggedFindingsConfiguration() {
        this.metrics.stream().map(MetricHolder::getDescriptor).forEach(metric -> this.addMetricDescriptor((MetricDescriptor)metric, CodeScopeAware.DEFAULT_CODE_SCOPE));
    }

    @Override
    public List<Class<? extends AnalysisConfigurationBase>> getRequiredConfigurations() {
        return Collections.singletonList(CoreConfiguration.class);
    }

    @Override
    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration(this);
        ArrayList<ConfigurationItemBase> items = new ArrayList<ConfigurationItemBase>();
        for (MetricHolder metricHolder : this.metrics) {
            items.add(metricHolder.getDescriptor());
        }
        template.registerConfigurationItems(ADDITIONAL_FINDING_METRICS_ANALYSIS_GROUP_NAME, null, items);
    }

    @Override
    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.registerFlaggedFindingsMetrics(proxy.getCodeMetricSchema());
    }

    private void registerFlaggedFindingsMetrics(MetricSchemaProxy schema) throws ProjectConfigurationException {
        for (MetricHolder m : this.metrics) {
            if (!m.getDescriptor().isMetricEnabled()) continue;
            m.getMetric().registerInSchema(schema);
        }
    }

    private static class MetricHolder {
        private static final boolean DEFAULT_ENABLED = false;
        private final MetricDescriptor descriptor;
        private final BlacklistCountMetric metric;

        MetricHolder(BlacklistCountMetric metric) {
            this(metric, false);
        }

        MetricHolder(BlacklistCountMetric metric, boolean enabled) {
            this.metric = metric;
            this.descriptor = MetricHolder.createMetricDescriptor(metric, enabled);
        }

        public MetricDescriptor getDescriptor() {
            return this.descriptor;
        }

        public BlacklistCountMetric getMetric() {
            return this.metric;
        }

        private static MetricDescriptor createMetricDescriptor(BlacklistCountMetric metric, boolean enabled) {
            return new MetricDescriptor(metric.getName(), metric.getDescription(), enabled);
        }
    }
}

