/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.optional;

import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OptionalWithException<T> {
    private final Optional<T> inner;

    private OptionalWithException(Optional<T> inner) {
        this.inner = inner;
    }

    public static <T> OptionalWithException<T> ofNullable(@Nullable T inner) {
        return OptionalWithException.wrap(Optional.ofNullable(inner));
    }

    public static <T> OptionalWithException<T> wrap(Optional<T> optional) {
        return new OptionalWithException<T>(optional);
    }

    public Optional<T> getOptional() {
        return this.inner;
    }

    public <E extends Exception, R> OptionalWithException<R> map(FunctionWithException<T, @Nullable R, E> mapper) throws E {
        if (this.inner.isEmpty()) {
            return OptionalWithException.wrap(Optional.empty());
        }
        return OptionalWithException.wrap(Optional.ofNullable(mapper.apply(this.inner.get())));
    }

    public <E extends Exception> T orElseGet(SupplierWithException<? extends T, ? extends E> supplier) throws E {
        if (this.inner.isPresent()) {
            return this.inner.get();
        }
        return (T)supplier.get();
    }

    public @Nullable T orElse(@Nullable T defaultValue) {
        return this.inner.orElse(defaultValue);
    }

    public <E extends Exception> void ifPresentOrElse(ConsumerWithException<? super T, E> action, RunnableWithException<E> emptyAction) throws E {
        if (this.inner.isPresent()) {
            action.accept(this.inner.get());
        } else {
            emptyAction.run();
        }
    }

    public <E extends Exception> void ifPresent(ConsumerWithException<? super T, E> action) throws E {
        if (this.inner.isPresent()) {
            action.accept(this.inner.get());
        }
    }
}

