/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.regex.finders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonarsource.analyzer.commons.regex.RegexIssueLocation;
import org.sonarsource.analyzer.commons.regex.RegexIssueReporter;
import org.sonarsource.analyzer.commons.regex.RegexParseResult;
import org.sonarsource.analyzer.commons.regex.ast.CharacterRangeTree;
import org.sonarsource.analyzer.commons.regex.ast.EscapedCharacterClassTree;
import org.sonarsource.analyzer.commons.regex.ast.NonCapturingGroupTree;
import org.sonarsource.analyzer.commons.regex.ast.RegexBaseVisitor;
import org.sonarsource.analyzer.commons.regex.ast.RegexSyntaxElement;
import org.sonarsource.analyzer.commons.regex.ast.RegexTree;

public class UnicodeUnawareCharClassFinder
extends RegexBaseVisitor {
    private static final List<Character> unicodeAwareClassesWithFlag = Arrays.asList(Character.valueOf('s'), Character.valueOf('S'), Character.valueOf('w'), Character.valueOf('W'));
    private static final Set<String> unicodeAwarePropertiesWithFlag = new HashSet<String>(Arrays.asList("Lower", "Upper", "Alpha", "Alnum", "Punct", "Graph", "Print", "Blank", "Space"));
    private static final Map<Character, Character> unicodeUnawareCharacterRanges = new HashMap<Character, Character>();
    private final RegexIssueReporter.ElementIssue regexElementIssueReporter;
    private final RegexIssueReporter.InvocationIssue invocationIssueReporter;
    private final List<CharacterRangeTree> unicodeUnawareRanges = new ArrayList<CharacterRangeTree>();
    private final List<RegexTree> unicodeAwareWithFlag = new ArrayList<RegexTree>();
    private boolean containsUnicodeCharacterFlag = false;

    public UnicodeUnawareCharClassFinder(RegexIssueReporter.ElementIssue regexElementIssueReporter, RegexIssueReporter.InvocationIssue invocationIssueReporter) {
        this.regexElementIssueReporter = regexElementIssueReporter;
        this.invocationIssueReporter = invocationIssueReporter;
    }

    @Override
    protected void before(RegexParseResult regexParseResult) {
        this.containsUnicodeCharacterFlag |= regexParseResult.getInitialFlags().contains(256);
    }

    @Override
    protected void after(RegexParseResult regexParseResult) {
        List<RegexIssueLocation> secondaries;
        int unicodeUnawareRangeSize = this.unicodeUnawareRanges.size();
        if (unicodeUnawareRangeSize == 1) {
            this.regexElementIssueReporter.report(this.unicodeUnawareRanges.get(0), "Replace this character range with a Unicode-aware character class.", null, Collections.emptyList());
        } else if (unicodeUnawareRangeSize > 1) {
            secondaries = this.unicodeUnawareRanges.stream().map(tree -> new RegexIssueLocation((RegexSyntaxElement)tree, "Character range")).collect(Collectors.toList());
            this.regexElementIssueReporter.report(regexParseResult.getResult(), "Replace these character ranges with Unicode-aware character classes.", null, secondaries);
        }
        if (!this.unicodeAwareWithFlag.isEmpty() && !this.containsUnicodeCharacterFlag) {
            secondaries = this.unicodeAwareWithFlag.stream().map(tree -> new RegexIssueLocation((RegexSyntaxElement)tree, "Predefined/POSIX character class")).collect(Collectors.toList());
            this.invocationIssueReporter.report("Enable the \"u\" flag or use a Unicode-aware alternative.", null, secondaries);
        }
    }

    @Override
    public void visitCharacterRange(CharacterRangeTree tree) {
        Character expectedUpperBoundChar;
        int lowerBound = tree.getLowerBound().codePointOrUnit();
        if (lowerBound < 65535 && (expectedUpperBoundChar = unicodeUnawareCharacterRanges.get(Character.valueOf((char)lowerBound))) != null && expectedUpperBoundChar.charValue() == tree.getUpperBound().codePointOrUnit()) {
            this.unicodeUnawareRanges.add(tree);
        }
    }

    @Override
    public void visitEscapedCharacterClass(EscapedCharacterClassTree tree) {
        String property = tree.property();
        if (property != null && unicodeAwarePropertiesWithFlag.contains(property) || unicodeAwareClassesWithFlag.contains(Character.valueOf(tree.getType()))) {
            this.unicodeAwareWithFlag.add(tree);
        }
    }

    @Override
    public void visitNonCapturingGroup(NonCapturingGroupTree tree) {
        this.containsUnicodeCharacterFlag |= tree.activeFlags().contains(256);
        super.visitNonCapturingGroup(tree);
    }

    static {
        unicodeUnawareCharacterRanges.put(Character.valueOf('a'), Character.valueOf('z'));
        unicodeUnawareCharacterRanges.put(Character.valueOf('A'), Character.valueOf('Z'));
    }
}

