/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.cfg.CfgBlock;
import org.sonar.plugins.php.api.cfg.ControlFlowGraph;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S1763")
public class CodeFollowingJumpStatementCheck
extends PHPSubscriptionCheck {
    public static final String KEY = "S1763";
    private static final String MESSAGE = "Delete this unreachable code or refactor the code to make it reachable.";
    private static final String SECONDARY_MESSAGE = "Statement exiting the current code block.";

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return new ArrayList<Tree.Kind>(ControlFlowGraph.KINDS_WITH_CONTROL_FLOW);
    }

    @Override
    public void visitNode(Tree tree) {
        ControlFlowGraph cfg = ControlFlowGraph.build(tree, this.context());
        if (cfg != null) {
            this.checkCfg(cfg);
        }
    }

    private void checkCfg(ControlFlowGraph cfg) {
        for (CfgBlock cfgBlock : cfg.blocks()) {
            Tree firstElement;
            if (!cfgBlock.predecessors().isEmpty() || cfgBlock.equals(cfg.start()) || cfgBlock.elements().isEmpty() || (firstElement = cfgBlock.elements().get(0)).is(Tree.Kind.BREAK_STATEMENT) && firstElement.getParent().is(Tree.Kind.CASE_CLAUSE, Tree.Kind.DEFAULT_CLAUSE) || CheckUtils.isClosingTag(firstElement)) continue;
            PreciseIssue issue = this.context().newIssue(this, firstElement, MESSAGE);
            cfg.blocks().stream().filter(block -> cfgBlock.equals(block.syntacticSuccessor())).forEach(block -> issue.secondary(block.elements().get(block.elements().size() - 1), SECONDARY_MESSAGE));
        }
    }
}

