/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S4829")
public class StandardInputUsageCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Make sure that reading the standard input is safe here.";
    private static final String STDIN = "STDIN";
    private static final String PHP_STDIN = "php://stdin";
    private static final List<String> SAFE_FUNCTIONS = Arrays.asList("fclose", "feof", "fseek", "fstat", "ftell", "ftruncate", "posix_isatty", "stream_set_blocking");

    @Override
    public void visitNamespaceName(NamespaceNameTree tree) {
        if (STDIN.equalsIgnoreCase(tree.qualifiedName())) {
            this.checkUsage(tree);
        }
    }

    @Override
    public void visitLiteral(LiteralTree tree) {
        if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL) && PHP_STDIN.equals(CheckUtils.trimQuotes(tree))) {
            this.checkUsage(tree);
        }
    }

    private void checkUsage(Tree tree) {
        Tree parent = tree.getParent();
        if (!(parent instanceof BinaryExpressionTree || parent instanceof UnaryExpressionTree || StandardInputUsageCheck.isArgumentOfSafeFunctionCall(tree))) {
            this.context().newIssue(this, tree, MESSAGE);
        }
    }

    private static boolean isArgumentOfSafeFunctionCall(Tree tree) {
        if (!tree.getParent().is(Tree.Kind.CALL_ARGUMENT) || !tree.getParent().getParent().is(Tree.Kind.FUNCTION_CALL)) {
            return false;
        }
        FunctionCallTree functionCall = (FunctionCallTree)tree.getParent().getParent();
        ExpressionTree callee = functionCall.callee();
        if (callee.is(Tree.Kind.NAMESPACE_NAME)) {
            String qualifiedName = ((NamespaceNameTree)callee).qualifiedName();
            return SAFE_FUNCTIONS.stream().anyMatch(qualifiedName::equalsIgnoreCase);
        }
        return false;
    }
}

