/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.ClassSymbolIndex;
import org.sonar.php.symbols.FunctionSymbol;
import org.sonar.php.symbols.FunctionSymbolIndex;
import org.sonar.php.symbols.MethodSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.php.tree.impl.declaration.ClassNamespaceNameTreeImpl;
import org.sonar.php.tree.impl.expression.FunctionCallTreeImpl;
import org.sonar.php.tree.symbols.NamespaceNameResolvingVisitor;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.expression.AnonymousClassTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NameIdentifierTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;

class SymbolUsageVisitor
extends NamespaceNameResolvingVisitor {
    private final ClassSymbolIndex classSymbolIndex;
    private final FunctionSymbolIndex functionSymbolIndex;
    private final ArrayDeque<ClassSymbol> currentClassSymbolStack = new ArrayDeque();

    SymbolUsageVisitor(SymbolTableImpl symbolTable, ClassSymbolIndex classSymbolIndex, FunctionSymbolIndex functionSymbolIndex) {
        super(symbolTable);
        this.classSymbolIndex = classSymbolIndex;
        this.functionSymbolIndex = functionSymbolIndex;
    }

    @Override
    public void visitNamespaceName(NamespaceNameTree tree) {
        if (tree instanceof ClassNamespaceNameTreeImpl) {
            ClassNamespaceNameTreeImpl classNamespaceName = (ClassNamespaceNameTreeImpl)tree;
            this.resolveClassSymbol(classNamespaceName);
        }
        super.visitNamespaceName(tree);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        super.visitFunctionCall(tree);
        ExpressionTree callee = tree.callee();
        if (callee.is(Tree.Kind.NAMESPACE_NAME) && !SymbolUsageVisitor.isNewExpressionCall(tree)) {
            QualifiedName fqn = this.getFullyQualifiedName((NamespaceNameTree)callee, Symbol.Kind.FUNCTION);
            FunctionSymbol functionSymbol = this.functionSymbolIndex.get(fqn);
            ((FunctionCallTreeImpl)tree).setSymbol(functionSymbol);
        } else if (callee.is(Tree.Kind.OBJECT_MEMBER_ACCESS, Tree.Kind.CLASS_MEMBER_ACCESS)) {
            this.resolveMethodCall(tree, (MemberAccessTree)callee);
        }
    }

    private void resolveMethodCall(FunctionCallTree tree, MemberAccessTree callee) {
        ClassSymbol receiverSymbol = null;
        ExpressionTree object = callee.object();
        if (!this.currentClassSymbolStack.isEmpty() && (SymbolUsageVisitor.isSelfOrStatic(object) || SymbolUsageVisitor.isThis(object))) {
            receiverSymbol = this.currentClassSymbolStack.getFirst();
        } else if (callee.is(Tree.Kind.CLASS_MEMBER_ACCESS) && object.is(Tree.Kind.NAMESPACE_NAME)) {
            receiverSymbol = ((ClassNamespaceNameTreeImpl)object).symbol();
        }
        if (receiverSymbol != null && callee.member().is(Tree.Kind.NAME_IDENTIFIER)) {
            String methodName = ((NameIdentifierTree)callee.member()).text();
            MethodSymbol methodSymbol = receiverSymbol.getDeclaredMethod(methodName);
            Optional<ClassSymbol> superClass = receiverSymbol.superClass();
            HashSet<ClassSymbol> processedClasses = new HashSet<ClassSymbol>();
            while (superClass.isPresent() && methodSymbol.isUnknownSymbol() && processedClasses.add(superClass.get())) {
                methodSymbol = superClass.get().getDeclaredMethod(methodName);
                superClass = superClass.get().superClass();
            }
            ((FunctionCallTreeImpl)tree).setSymbol(methodSymbol);
        }
    }

    public static boolean isNewExpressionCall(FunctionCallTree functionCallTree) {
        return functionCallTree.getParent() != null && functionCallTree.getParent().is(Tree.Kind.NEW_EXPRESSION);
    }

    public static boolean isThis(Tree object) {
        return object.is(Tree.Kind.VARIABLE_IDENTIFIER) && ((VariableIdentifierTree)object).text().equals("$this");
    }

    public static boolean isSelfOrStatic(Tree object) {
        return object.is(Tree.Kind.NAMESPACE_NAME) && ((NamespaceNameTree)object).fullName().equals("self") || object.is(Tree.Kind.NAME_IDENTIFIER) && ((NameIdentifierTree)object).text().equals("static");
    }

    @Override
    public void visitAnonymousClass(AnonymousClassTree tree) {
        this.currentClassSymbolStack.push(Symbols.get(tree));
        super.visitAnonymousClass(tree);
        this.currentClassSymbolStack.pop();
    }

    @Override
    public void visitClassDeclaration(ClassDeclarationTree tree) {
        this.currentClassSymbolStack.push(Symbols.get(tree));
        super.visitClassDeclaration(tree);
        this.currentClassSymbolStack.pop();
    }

    private void resolveClassSymbol(ClassNamespaceNameTreeImpl namespaceName) {
        QualifiedName fqn = this.getFullyQualifiedName(namespaceName, Symbol.Kind.CLASS);
        ClassSymbol classSymbol = this.classSymbolIndex.get(fqn);
        namespaceName.setSymbol(classSymbol);
    }
}

