/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports;

import java.io.File;
import java.nio.file.Path;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.sensor.SensorContext;

public class ExternalReportFileHandler {
    private final FileSystem fileSystem;
    private int relativePathOffset = 0;

    private ExternalReportFileHandler(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public static ExternalReportFileHandler create(SensorContext context) {
        return new ExternalReportFileHandler(context.fileSystem());
    }

    public String relativePath(String fileName) {
        if (this.isKnownFile(fileName)) {
            return fileName;
        }
        String normalizedPath = ExternalReportFileHandler.separatorsToSystem(fileName);
        if (normalizedPath == null) {
            return fileName;
        }
        Path path = Path.of(normalizedPath, new String[0]);
        int pathNameCount = path.getNameCount();
        if (this.relativePathOffset > 0) {
            if (path.getNameCount() > this.relativePathOffset && this.isKnownFile(path = path.subpath(this.relativePathOffset, pathNameCount))) {
                return path.toString();
            }
            return fileName;
        }
        for (int i = 1; i < pathNameCount; ++i) {
            Path subpath = path.subpath(i, pathNameCount);
            if (!this.isKnownFile(subpath)) continue;
            this.relativePathOffset = i;
            return subpath.toString();
        }
        return fileName;
    }

    private boolean isKnownFile(Path path) {
        return this.isKnownFile(path.toString());
    }

    private boolean isKnownFile(String path) {
        return this.fileSystem.hasFiles(this.fileSystem.predicates().hasPath(path));
    }

    private static String separatorsToSystem(String path) {
        return ExternalReportFileHandler.isSystemWindows() ? ExternalReportFileHandler.separatorsToWindows(path) : ExternalReportFileHandler.separatorsToUnix(path);
    }

    private static boolean isSystemWindows() {
        return File.separatorChar == '\\';
    }

    private static String separatorsToUnix(String path) {
        return path.indexOf(92) != -1 ? path.replace('\\', '/') : path;
    }

    private static String separatorsToWindows(String path) {
        return path.indexOf(47) != -1 ? path.replace('/', '\\') : path;
    }
}

