/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.SequencedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.UnmodifiableIterator;
import org.conqat.lib.commons.collections.UnmodifiableSequencedSet;

final class UnmodifiableSequencedSetImpl<E>
implements UnmodifiableSequencedSet<E> {
    private static final long serialVersionUID = 1L;
    private final SequencedSet<E> sequencedSet;

    public UnmodifiableSequencedSetImpl(SequencedSet<E> sequencedSet) {
        this.sequencedSet = Collections.unmodifiableSequencedSet(sequencedSet);
    }

    @Override
    public UnmodifiableSequencedSet<E> reversed() {
        return UnmodifiableSequencedSet.of(this.sequencedSet.reversed());
    }

    @Override
    public @NonNull UnmodifiableIterator<E> iterator() {
        return UnmodifiableIterator.of(this.sequencedSet.iterator());
    }

    @Override
    public int size() {
        return this.sequencedSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.sequencedSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.sequencedSet.contains(o);
    }

    @Override
    public Object @NonNull [] toArray() {
        return this.sequencedSet.toArray();
    }

    @Override
    public <T> T @NonNull [] toArray(T @NonNull [] a) {
        return this.sequencedSet.toArray(a);
    }

    @Override
    public boolean containsAll(@NonNull Collection<?> c) {
        return this.sequencedSet.containsAll(c);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.sequencedSet.toArray(generator);
    }

    @Override
    public Stream<E> stream() {
        return this.sequencedSet.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.sequencedSet.parallelStream();
    }

    @Override
    public E getFirst() {
        return this.sequencedSet.getFirst();
    }

    @Override
    public E getLast() {
        return this.sequencedSet.getLast();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.sequencedSet.spliterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.sequencedSet.forEach(action);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UnmodifiableSequencedSetImpl) {
            UnmodifiableSequencedSetImpl that = (UnmodifiableSequencedSetImpl)o;
            return this.sequencedSet.equals(that.sequencedSet);
        }
        return this.sequencedSet.equals(o);
    }

    @Override
    public int hashCode() {
        return this.sequencedSet.hashCode();
    }

    public String toString() {
        return this.sequencedSet.toString();
    }
}

