/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.trilead;

import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.auth.AgentProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.internal.io.svn.ssh.SshSessionPool;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.SshHost;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.SshHostDisposedException;
import org.tmatesoft.svn.core.internal.io.svn.ssh.trilead.TrileadSshSession;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class TrileadSshSessionPool
implements SshSessionPool {
    private static final long PURGE_INTERVAL = 10000L;
    private Map<String, SshHost> myPool = new HashMap<String, SshHost>();
    private Timer myTimer = new Timer(true);

    public TrileadSshSessionPool() {
        this.myTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = TrileadSshSessionPool.this.myPool;
                synchronized (map) {
                    ArrayList hosts = new ArrayList(TrileadSshSessionPool.this.myPool.values());
                    for (SshHost host : hosts) {
                        if (host.purge()) {
                            TrileadSshSessionPool.this.myPool.remove(host.getKey());
                        }
                        SVNDebugLog.getDefaultLog().logFinest(SVNLogType.NETWORK, "SSH pool, purged: " + host);
                    }
                }
            }
        }, 10000L, 10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Map<String, SshHost> map = this.myPool;
        synchronized (map) {
            ArrayList<SshHost> hosts = new ArrayList<SshHost>(this.myPool.values());
            for (SshHost host : hosts) {
                try {
                    host.lock();
                    host.setDisposed(true);
                    this.myPool.remove(host.getKey());
                }
                finally {
                    host.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrileadSshSession openSession(String host, int port, String userName, char[] privateKey, char[] passphrase, char[] password, AgentProxy agentProxy, final ISVNSSHHostVerifier verifier, int connectTimeout, int readTimeout) throws IOException {
        ServerHostKeyVerifier v = new ServerHostKeyVerifier(){

            public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
                if (verifier != null) {
                    verifier.verifyHostKey(hostname, port, serverHostKeyAlgorithm, serverHostKey);
                }
                return true;
            }
        };
        SshHost newHost = new SshHost(host, port);
        newHost.setCredentials(userName, privateKey, passphrase, password, agentProxy);
        newHost.setConnectionTimeout(connectTimeout);
        newHost.setHostVerifier(v);
        newHost.setReadTimeout(readTimeout);
        TrileadSshSession session = null;
        String hostKey = newHost.getKey();
        while (session == null) {
            SshHost sshHost;
            Map<String, SshHost> map = this.myPool;
            synchronized (map) {
                sshHost = this.myPool.get(hostKey);
                if (sshHost == null) {
                    sshHost = newHost;
                    this.myPool.put(hostKey, newHost);
                }
            }
            try {
                session = sshHost.openSession();
                break;
            }
            catch (SshHostDisposedException e) {
                Map<String, SshHost> map2 = this.myPool;
                synchronized (map2) {
                    this.myPool.remove(hostKey);
                }
            }
        }
        return session;
    }
}

