/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser;

import com.teamscale.reportparser.CoverageReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.xml.OfflineSaxHandlerBase;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DotCoverReportParser
extends CoverageReportParserBase {
    private static final String DOTCOVER_REPORT_DTD_FILE = "dotCover/dotCover-report-v10_0_2.dtd";
    private static final String DOTCOVER_REPORT_2019_2_2_DTD_FILE = "dotCover/dotCover-report-v2019_2_2.dtd";

    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever retriever) throws ReportParserException {
        try {
            if (!XMLUtils.validateAgainstDTD((String)report, (String)Resource.of(this.getClass(), (String)DOTCOVER_REPORT_DTD_FILE).getContent()) && !XMLUtils.validateAgainstDTD((String)report, (String)Resource.of(this.getClass(), (String)DOTCOVER_REPORT_2019_2_2_DTD_FILE).getContent())) {
                LOGGER.error("The dotCover report does not match the expected format.\nMake sure a DetailedXML report is uploaded!\nSelect \"Export to detailed XML\" when exporting reports in Visual Studio or set the ReportType Flag to DetailedXML when using the console runner.\nStill trying to parse the report.");
            }
            XMLUtils.parseSAX((String)report, (DefaultHandler)((Object)new DotCoverXmlHandler(retriever)));
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            throw new ReportParserException(e);
        }
    }

    public static class DotCoverXmlHandler
    extends OfflineSaxHandlerBase {
        private final CoverageInfoRetriever retriever;
        private final ListMap<String, Integer> coveredLinesByFileId = new ListMap();
        private final ListMap<String, Integer> uncoveredLinesByFileId = new ListMap();
        private final Map<String, String> fileIdToFileLocation = new HashMap<String, String>();

        public DotCoverXmlHandler(CoverageInfoRetriever retriever) {
            this.retriever = retriever;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            switch (qName) {
                case "Statement": {
                    String fileId = DotCoverXmlHandler.getRequiredAttribute(attributes, "FileIndex");
                    boolean wasCovered = DotCoverXmlHandler.getRequiredAttribute(attributes, "Covered").equals("True");
                    int startLine = Integer.parseInt(DotCoverXmlHandler.getRequiredAttribute(attributes, "Line"));
                    String endLineString = attributes.getValue("EndLine");
                    if (endLineString == null) {
                        this.addLines(wasCovered, fileId, startLine, startLine);
                        break;
                    }
                    this.addLines(wasCovered, fileId, startLine, Integer.parseInt(endLineString));
                    break;
                }
                case "File": {
                    String fileIndex = DotCoverXmlHandler.getRequiredAttribute(attributes, "Index");
                    String fileLocation = DotCoverXmlHandler.getRequiredAttribute(attributes, "Name");
                    this.fileIdToFileLocation.put(fileIndex, fileLocation);
                }
            }
        }

        private void addLines(boolean wasCovered, String fileId, int startLineInclusive, int endLineInclusive) {
            for (int i = startLineInclusive; i <= endLineInclusive; ++i) {
                if (wasCovered) {
                    this.coveredLinesByFileId.add((Object)fileId, (Object)i);
                    continue;
                }
                this.uncoveredLinesByFileId.add((Object)fileId, (Object)i);
            }
        }

        private static String getRequiredAttribute(Attributes attributes, String attributeName) {
            String value = attributes.getValue(attributeName);
            CCSMAssert.isNotNull((Object)value, (String)("Missing required attribute '" + attributeName + "'"));
            return value;
        }

        public void endElement(String uri, String localName, String qName) {
            if (!qName.equals("Root")) {
                return;
            }
            for (Map.Entry<String, String> entry : this.fileIdToFileLocation.entrySet()) {
                List uncoveredLines;
                String fileId = entry.getKey();
                LineCoverageInfo lineCoverageInfo = this.retriever.getOrCreateLineCoverageInfo(entry.getValue());
                List coveredLines = (List)this.coveredLinesByFileId.getCollection((Object)fileId);
                if (coveredLines != null) {
                    lineCoverageInfo.addLineCoverage((Collection)coveredLines, ELineCoverage.FULLY_COVERED);
                }
                if ((uncoveredLines = (List)this.uncoveredLinesByFileId.getCollection((Object)fileId)) == null) continue;
                lineCoverageInfo.addLineCoverage((Collection)uncoveredLines, ELineCoverage.NOT_COVERED);
            }
        }
    }
}

