/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import org.conqat.engine.sourcecode.coverage.volume.condition.AdaConditionExtractor;
import org.conqat.engine.sourcecode.coverage.volume.condition.CLikeConditionExtractor;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionExtractor;
import org.conqat.engine.sourcecode.coverage.volume.condition.PythonConditionExtractor;
import org.conqat.engine.sourcecode.coverage.volume.condition.SplitSubConditionParser;
import org.conqat.engine.sourcecode.coverage.volume.condition.SubConditionParserBase;

public class ConditionParserFactory {
    private static final Map<ELanguage, IConditionExtractor> CONDITION_EXTRACTORS = new EnumMap<ELanguage, IConditionExtractor>(ELanguage.class);
    private static final Map<ELanguage, SubConditionParserBase> SUB_CONDITION_PARSERS = new EnumMap<ELanguage, SubConditionParserBase>(ELanguage.class);

    private static void registerLanguage(ELanguage language, IConditionExtractor conditionExtractor, SubConditionParserBase subConditionParser) {
        CONDITION_EXTRACTORS.put(language, conditionExtractor);
        SUB_CONDITION_PARSERS.put(language, subConditionParser);
    }

    public static IConditionExtractor createConditionExtractor(ELanguage language) {
        return CONDITION_EXTRACTORS.get(language);
    }

    public static SubConditionParserBase createSubConditionParser(ELanguage language) {
        return SUB_CONDITION_PARSERS.get(language);
    }

    public static boolean supportsLanguage(ELanguage language) {
        return CONDITION_EXTRACTORS.containsKey(language) && SUB_CONDITION_PARSERS.containsKey(language);
    }

    static {
        ConditionParserFactory.registerLanguage(ELanguage.JAVA, new CLikeConditionExtractor(ELanguage.JAVA), new SplitSubConditionParser(EnumSet.of(ETokenType.ANDAND, ETokenType.OROR), EnumSet.of(ETokenType.AND, ETokenType.OR)));
        ConditionParserFactory.registerLanguage(ELanguage.CPP, new CLikeConditionExtractor(ELanguage.CPP), new SplitSubConditionParser(EnumSet.of(ETokenType.ANDAND, ETokenType.OROR)));
        ConditionParserFactory.registerLanguage(ELanguage.CPP_MS_CLI, new CLikeConditionExtractor(ELanguage.CPP_MS_CLI), new SplitSubConditionParser(EnumSet.of(ETokenType.ANDAND, ETokenType.OROR)));
        ConditionParserFactory.registerLanguage(ELanguage.C, new CLikeConditionExtractor(ELanguage.C), new SplitSubConditionParser(EnumSet.of(ETokenType.ANDAND, ETokenType.OROR)));
        ConditionParserFactory.registerLanguage(ELanguage.CS, new CLikeConditionExtractor(ELanguage.CS), new SplitSubConditionParser(EnumSet.of(ETokenType.ANDAND, ETokenType.OROR)));
        ConditionParserFactory.registerLanguage(ELanguage.JAVASCRIPT, new CLikeConditionExtractor(ELanguage.JAVASCRIPT), new SplitSubConditionParser(EnumSet.of(ETokenType.ANDAND, ETokenType.OROR)));
        ConditionParserFactory.registerLanguage(ELanguage.ADA, new AdaConditionExtractor(), new SplitSubConditionParser(EnumSet.of(ETokenType.AND, ETokenType.OR, ETokenType.XOR)));
        ConditionParserFactory.registerLanguage(ELanguage.PYTHON, new PythonConditionExtractor(), new SplitSubConditionParser(EnumSet.of(ETokenType.AND, ETokenType.OR)));
    }
}

