/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionEvaluatorBase;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeFalse;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeTrue;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IOperatorInformation;

public class PythonConditionEvaluator
extends ConditionEvaluatorBase {
    private static final String ZERO_REPRESENTATION = "-?(0|0.0)";
    private static final IOperatorInformation OPERATOR_INFORMATION = new PythonOperatorInformation(List.of(Set.of(ETokenType.OROR), Set.of(ETokenType.ANDAND), Set.of(ETokenType.NOT), Set.of(ETokenType.OR), Set.of(ETokenType.XOR), Set.of(ETokenType.AND), Set.of(ETokenType.IS, ETokenType.IS_NOT, ETokenType.IN, ETokenType.NOT_IN), Set.of(ETokenType.EQEQ, ETokenType.NOTEQ), Set.of(ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ), Set.of(ETokenType.LSHIFT, ETokenType.RSHIFT), Set.of(ETokenType.PLUS, ETokenType.MINUS), Set.of(ETokenType.MULT, ETokenType.DIV, ETokenType.FLOOR_DIV, ETokenType.MOD), Set.of(ETokenType.BIT_NOT), Set.of(ETokenType.POWER)));

    public PythonConditionEvaluator() {
        this.negationsForRelational.put(ETokenType.IS, ETokenType.IS_NOT);
        this.negationsForRelational.put(ETokenType.IS_NOT, ETokenType.IS);
        this.negationsForRelational.put(ETokenType.IN, ETokenType.NOT_IN);
        this.negationsForRelational.put(ETokenType.NOT_IN, ETokenType.IN);
    }

    @Override
    protected ETokenType getAndOperator() {
        return ETokenType.ANDAND;
    }

    @Override
    protected ETokenType getOrOperator() {
        return ETokenType.OROR;
    }

    @Override
    protected ETokenType getClosingBracketType() {
        return ETokenType.RPAREN;
    }

    @Override
    protected ETokenType getOpeningBracketType() {
        return ETokenType.LPAREN;
    }

    @Override
    protected boolean isEqualOperator(ETokenType operator) {
        return operator == ETokenType.EQEQ || operator == ETokenType.IS;
    }

    @Override
    protected boolean isNotEqualOperator(ETokenType operator) {
        return operator == ETokenType.NOTEQ || operator == ETokenType.IS_NOT;
    }

    @Override
    public Set<ETokenType> getBooleanOperators() {
        return Set.of(PythonConditionEvaluator.getNegationOperator(), this.getAndOperator(), this.getOrOperator(), ETokenType.EQEQ, ETokenType.IS, ETokenType.NOTEQ, ETokenType.IS_NOT, ETokenType.LT, ETokenType.LTEQ, ETokenType.GT, ETokenType.GTEQ, ETokenType.IN, ETokenType.NOT_IN);
    }

    @Override
    public IConditionTreeNode castToBoolean(IConditionTreeNode originalNode, ExpressionTreeNode expression) {
        if (expression.getExpression().size() == 1) {
            return PythonConditionEvaluator.castLiteralToBoolean(originalNode, expression);
        }
        return PythonConditionEvaluator.castCollectionToBoolean(originalNode, expression);
    }

    private static IConditionTreeNode castLiteralToBoolean(IConditionTreeNode originalNode, ExpressionTreeNode expression) {
        IToken literalToken = expression.getExpression().get(0);
        ETokenType tokenType = literalToken.getType();
        switch (tokenType) {
            case INTEGER_LITERAL: 
            case FLOATING_POINT_LITERAL: {
                if (literalToken.getText().matches(ZERO_REPRESENTATION)) {
                    return new ConditionTreeNodeFalse();
                }
                return new ConditionTreeNodeTrue();
            }
            case STRING_LITERAL: {
                if (literalToken.getText().isEmpty()) {
                    return new ConditionTreeNodeFalse();
                }
                return new ConditionTreeNodeTrue();
            }
        }
        if (tokenType.getTokenClass() == ETokenType.ETokenClass.LITERAL) {
            return new ConditionTreeNodeTrue();
        }
        return originalNode;
    }

    private static IConditionTreeNode castCollectionToBoolean(IConditionTreeNode originalNode, ExpressionTreeNode expression) {
        int rightIndex;
        List<IToken> tokens = expression.getExpression();
        int leftIndex = 0;
        for (rightIndex = tokens.size() - 1; leftIndex < rightIndex && tokens.get(leftIndex).getType() == ETokenType.LPAREN && TokenStreamUtils.findMatchingClosingToken(tokens, (int)leftIndex, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN) == rightIndex; ++leftIndex, --rightIndex) {
        }
        if (leftIndex >= rightIndex || tokens.size() == 2 && tokens.get(0).getType() == ETokenType.LPAREN && tokens.get(1).getType() == ETokenType.RPAREN) {
            return new ConditionTreeNodeFalse();
        }
        if (tokens.get(leftIndex).getType() == ETokenType.LBRACK && tokens.get(rightIndex).getType() == ETokenType.RBRACK || tokens.get(leftIndex).getType() == ETokenType.LBRACE && tokens.get(rightIndex).getType() == ETokenType.RBRACE) {
            if (leftIndex + 1 == rightIndex) {
                return new ConditionTreeNodeFalse();
            }
            return new ConditionTreeNodeTrue();
        }
        return originalNode;
    }

    @Override
    public boolean supportsImplicitBooleanCast() {
        return true;
    }

    @Override
    public IOperatorInformation getOperatorInformation() {
        return OPERATOR_INFORMATION;
    }

    private record PythonOperatorInformation(List<Set<ETokenType>> operatorsByPrecedence) implements IOperatorInformation
    {
        @Override
        public Set<List<ETokenType>> getAllowedEmptyCollections() {
            return Set.of(List.of(ETokenType.LPAREN, ETokenType.RPAREN));
        }

        @Override
        public List<IToken> preprocessTokens(List<IToken> tokens) {
            if (tokens.size() == 1) {
                return new ArrayList<IToken>(tokens);
            }
            ArrayList<IToken> newTokens = new ArrayList<IToken>();
            for (int position = 0; position < tokens.size(); ++position) {
                if (tokens.get(position).getType() == ETokenType.IS && position < tokens.size() - 1 && tokens.get(position + 1).getType() == ETokenType.NOT) {
                    newTokens.add(tokens.get(position).newToken(ETokenType.IS_NOT, tokens.get(position).getOffset(), tokens.get(position).getLineNumber(), "is not", tokens.get(position).getOriginId()));
                    ++position;
                    continue;
                }
                if (tokens.get(position).getType() == ETokenType.NOT && position < tokens.size() - 1 && tokens.get(position + 1).getType() == ETokenType.IN) {
                    newTokens.add(tokens.get(position).newToken(ETokenType.NOT_IN, tokens.get(position).getOffset(), tokens.get(position).getLineNumber(), "not in", tokens.get(position).getOriginId()));
                    ++position;
                    continue;
                }
                newTokens.add(tokens.get(position));
            }
            return newTokens;
        }
    }
}

