/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.config;

import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authentication.RequiresNoLogin;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/shadow-mode")
public class ShadowModeService
extends ApiBase {
    @GET
    @Produces(value={"text/plain"})
    @Operation(summary="Get shadow mode state", description="Allows to determine whether the server is in shadow mode state or not.")
    @RequiresNoLogin
    public boolean getShadowModeState() {
        try {
            return ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)this.getGlobalStorageSystem());
        }
        catch (StorageException e) {
            throw new InternalServerErrorException("Could not retrieve the shadow mode setting from the database: " + e.getMessage(), (Throwable)e);
        }
    }
}

