/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.findings.FindingsIndex;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.service.audit.exceptions_hierarchy.EExceptionSource;
import com.teamscale.service.audit.exceptions_hierarchy.ExceptionsTreeEdge;
import com.teamscale.service.base.ApiBase;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class ExceptionsHierarchyServiceBase
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    protected ProjectStorageSystem storageSystem;
    protected HistoryAccessOption historyOption;
    private static final String TYPE_ID = "Exception Handling/Custom Exception Definition";

    protected Set<ELanguage> getProjectLanguages(UnresolvedCommitDescriptor commit) throws StorageException {
        InternalProjectId projectId = this.serviceInfo.getInternalId();
        this.storageSystem = this.getProjectStorageSystem((IProjectId)projectId);
        this.historyOption = this.determineHistoryOption(commit);
        MetaIndex projectMetaIndex = (MetaIndex)this.storageSystem.openProjectIndex(MetaIndex.class, null);
        return AnalysisProfileUtils.getConfiguredLanguages((MetaIndex)projectMetaIndex);
    }

    private static List<IndexFinding> collectMatchingFindings(FindingsIndex findingsIndex, ELanguage hierarchyLanguage, String typeId) throws StorageException {
        ArrayList<IndexFinding> result = new ArrayList<IndexFinding>();
        for (Pair findingsIndexEntry : findingsIndex.getAllUniformPathsAndFindings()) {
            if (CollectionUtils.isNullOrEmpty((Collection)((Collection)findingsIndexEntry.getSecond()))) continue;
            for (IndexFinding finding : (List)findingsIndexEntry.getSecond()) {
                ELanguage findingInLanguage = ELanguage.fromPath((String)finding.getLocation().getUniformPath());
                if (!finding.getTypeId().equals(typeId) || findingInLanguage != hierarchyLanguage) continue;
                result.add(finding);
            }
        }
        return result;
    }

    protected List<ExceptionsTreeEdge> getExceptionTreeEdgesFromProject(ELanguage language) throws StorageException {
        FindingsIndex findingsIndex = (FindingsIndex)this.storageSystem.openProjectIndex(FindingsIndex.class, this.historyOption);
        List<IndexFinding> findings = ExceptionsHierarchyServiceBase.collectMatchingFindings(findingsIndex, language, TYPE_ID);
        return this.getExceptionsTreeEdgesFromProject(findings);
    }

    protected List<ExceptionsTreeEdge> getExceptionsTreeEdgesFromProject(List<IndexFinding> findings) throws StorageException {
        TypeIndex typeIndex = (TypeIndex)this.storageSystem.openProjectIndex(TypeIndex.class, this.historyOption);
        ArrayList<ExceptionsTreeEdge> result = new ArrayList<ExceptionsTreeEdge>();
        Set typeNames = typeIndex.getAllTypeNames();
        for (IndexFinding finding : findings) {
            String uniformPath = finding.getLocation().getUniformPath();
            TextRegionLocation regionLocation = (TextRegionLocation)finding.getLocation();
            String subclass = this.getClassNameDefinedAtLine(uniformPath, regionLocation.getRawStartLine());
            int prefixLength = "Custom Exception Definition which inherits from: ".length();
            String unqualifiedSuperclass = finding.getMessage().substring(prefixLength);
            String superclass = ExceptionsHierarchyServiceBase.getQualifiedNameOfClass(unqualifiedSuperclass, typeNames);
            result.add(new ExceptionsTreeEdge(subclass, superclass, EExceptionSource.APPLICATION_SOURCE_CODE));
        }
        return result;
    }

    protected String getClassNameDefinedAtLine(String uniformPath, int lineNumber) throws StorageException {
        TokenElementIndex tokenElementIndex = (TokenElementIndex)this.storageSystem.openProjectIndex(TokenElementIndex.class, "content", this.historyOption);
        UnmodifiableList entities = tokenElementIndex.getTokenElement(uniformPath).getShallowEntitiesWithoutPreprocessorTokens();
        List visitorResults = ShallowEntityTraversalUtils.selectEntities((Collection)entities, entity -> entity.getType() == EShallowEntityType.TYPE && entity.getStartLine() == lineNumber);
        CCSMAssert.isTrue((!visitorResults.isEmpty() ? 1 : 0) != 0, (String)("A class name derived from Exception could not be found at line " + lineNumber));
        return ((ShallowEntity)visitorResults.get(0)).getName();
    }

    private static String getQualifiedNameOfClass(String unqualifiedClassName, Set<String> allTypeNames) {
        ArrayList<String> qualifiedNames = new ArrayList<String>();
        String suffix = "." + unqualifiedClassName;
        for (String typeName : allTypeNames) {
            if (!typeName.endsWith(suffix)) continue;
            qualifiedNames.add(typeName);
        }
        return switch (qualifiedNames.size()) {
            case 0 -> unqualifiedClassName;
            case 1 -> (String)qualifiedNames.get(0);
            default -> {
                LOGGER.warn("Multiple exceptions end with the same suffix. One of them: {}", qualifiedNames.get(0));
                yield (String)qualifiedNames.get(0);
            }
        };
    }
}

