/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.service.audit.AuditUtils;
import com.teamscale.service.audit.CodeFileInfo;
import com.teamscale.service.audit.FileGroup;
import com.teamscale.service.base.ApiBase;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public abstract class FilesWithIdenticalPropertyServiceBase
extends ApiBase {
    public static final String PARAM_NAME_REGEX_FILTER = "regex";

    protected List<FileGroup> findFilesWithIdenticalProperties(String regex, HistoryAccessOption historyOption, UniformPath uniformPath) throws StorageException {
        List<UniformPath> uniformPaths = AuditUtils.getSubUniformPaths((IStorageInfo)this.serviceInfo, historyOption, uniformPath);
        Map<String, Set<UniformPath>> fileGroups = this.findAndGroupFilesNames(uniformPaths, regex);
        List<FileGroup> fileGroupsWithMetrics = this.enrichWithMetricInformation(fileGroups, historyOption);
        FilesWithIdenticalPropertyServiceBase.applySorting(fileGroupsWithMetrics);
        return fileGroupsWithMetrics;
    }

    private static void applySorting(List<FileGroup> fileGroups) {
        fileGroups.sort(new FileGroupComparator());
        for (FileGroup fileGroup : fileGroups) {
            fileGroup.files.sort(new FilesComparator());
        }
    }

    private List<FileGroup> enrichWithMetricInformation(Map<String, Set<UniformPath>> fileGroups, HistoryAccessOption historyOption) throws StorageException {
        MetricDirectoryIndex metricDirectoryIndex = this.openProjectIndex(MetricDirectoryIndex.class, "metrics-dir", historyOption);
        MetricDirectorySchema schema = this.openProjectIndex(MetricSchemaIndex.class, "metric-schema", historyOption.cloneToUnbranchedAccessOption()).getPublicSchema();
        ArrayList<FileGroup> result = new ArrayList<FileGroup>();
        for (Map.Entry<String, Set<UniformPath>> entry : fileGroups.entrySet()) {
            FileGroup group = new FileGroup(entry.getKey());
            result.add(group);
            for (UniformPath uniformPath : entry.getValue()) {
                group.addFileInfo(CodeFileInfo.create(uniformPath, metricDirectoryIndex, schema));
            }
        }
        return result;
    }

    protected Map<String, Set<UniformPath>> findAndGroupFilesNames(List<UniformPath> uniformPaths, String regex) throws StorageException {
        FilesWithIdenticalPropertyServiceBase.filterUniformPathsByRegex(uniformPaths, regex);
        Map<String, Set<UniformPath>> fileGroups = this.groupPaths(uniformPaths);
        this.filterFileGroups(fileGroups);
        return fileGroups;
    }

    protected void filterFileGroups(Map<String, Set<UniformPath>> fileGroups) {
        fileGroups.entrySet().removeIf(entry -> ((Set)entry.getValue()).size() < 2);
    }

    private static void filterUniformPathsByRegex(List<UniformPath> uniformPaths, String regex) {
        Pattern pattern = Pattern.compile(regex);
        if (!StringUtils.isEmpty((String)regex)) {
            uniformPaths.removeIf(path -> !pattern.matcher(path.toString()).find());
        }
    }

    protected abstract Map<String, Set<UniformPath>> groupPaths(List<UniformPath> var1) throws StorageException;

    private static class FileGroupComparator
    implements Comparator<FileGroup> {
        private FileGroupComparator() {
        }

        @Override
        public int compare(FileGroup o1, FileGroup o2) {
            return Comparator.comparing(fileGroup -> fileGroup.getFiles().size(), Comparator.reverseOrder()).thenComparing(FileGroup::getName).compare(o1, o2);
        }
    }

    private static class FilesComparator
    implements Comparator<CodeFileInfo> {
        private FilesComparator() {
        }

        @Override
        public int compare(CodeFileInfo o1, CodeFileInfo o2) {
            return Comparator.comparing(CodeFileInfo::getCloneCoverage, Comparator.reverseOrder()).thenComparing(CodeFileInfo::getSourceLinesOfCode, Comparator.reverseOrder()).thenComparing(CodeFileInfo::getUniformPath).compare(o1, o2);
        }
    }
}

