/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.exceptions_hierarchy;

import com.teamscale.commons.lang.ToStringHelpers;
import com.teamscale.service.audit.exceptions_hierarchy.EExceptionSource;
import java.util.Objects;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ExceptionsTreeEdge {
    private final String parentExceptionSimpleName;
    private final String exceptionSimpleName;
    private final EExceptionSource exceptionSource;

    public ExceptionsTreeEdge(String exceptionName, String parentExceptionName, EExceptionSource exceptionSource) {
        this.exceptionSimpleName = ExceptionsTreeEdge.toSimpleClassName(exceptionName);
        this.parentExceptionSimpleName = ExceptionsTreeEdge.toSimpleClassName(parentExceptionName);
        this.exceptionSource = exceptionSource;
    }

    public ExceptionsTreeEdge(String exceptionName, Class<?> parentException, EExceptionSource exceptionSource) {
        this(exceptionName, parentException.getSimpleName(), exceptionSource);
    }

    public ExceptionsTreeEdge(Class<?> exception, Class<?> parentException, EExceptionSource exceptionSource) {
        this(exception.getSimpleName(), parentException.getSimpleName(), exceptionSource);
    }

    public String getParentExceptionName() {
        return this.parentExceptionSimpleName;
    }

    public String getExceptionName() {
        return this.exceptionSimpleName;
    }

    public EExceptionSource getExceptionSource() {
        return this.exceptionSource;
    }

    public static String toSimpleClassName(String qualifiedClassName) {
        int dotPosition = qualifiedClassName.lastIndexOf(".");
        if (dotPosition == -1) {
            return qualifiedClassName;
        }
        CCSMAssert.isFalse((dotPosition + 1 > qualifiedClassName.length() ? 1 : 0) != 0, (String)("Class name cannot terminate with a dot: " + qualifiedClassName));
        return qualifiedClassName.substring(dotPosition + 1);
    }

    public int hashCode() {
        return this.exceptionSimpleName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExceptionsTreeEdge)) {
            return false;
        }
        ExceptionsTreeEdge other = (ExceptionsTreeEdge)obj;
        return Objects.equals(this.exceptionSimpleName, other.exceptionSimpleName);
    }

    public String toString() {
        return ToStringHelpers.toReflectiveStringHelper((Object)this).toString();
    }
}

