/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.exceptions_hierarchy;

import com.teamscale.service.audit.exceptions_hierarchy.EExceptionSource;
import com.teamscale.service.audit.exceptions_hierarchy.ExceptionsTree;
import com.teamscale.service.audit.exceptions_hierarchy.ExceptionsTreeEdge;
import com.teamscale.service.audit.exceptions_hierarchy.ILanguageSpecificExceptionSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExceptionsTreeManager {
    protected static final String NAME_FOR_EXCEPTIONS_WITHOUT_KNOWN_ROOT = "<Unknown root exception>";
    private final ILanguageSpecificExceptionSupport languageSupport;

    public ExceptionsTreeManager(ILanguageSpecificExceptionSupport languageSupport) {
        this.languageSupport = languageSupport;
    }

    public List<ExceptionsTree> createExceptionsTree(List<ExceptionsTreeEdge> exceptionTreeEdgesFromProject) {
        ArrayList<ExceptionsTreeEdge> allExceptionEdges = new ArrayList<ExceptionsTreeEdge>();
        allExceptionEdges.addAll(this.languageSupport.getLanguageSpecificExceptions());
        allExceptionEdges.addAll(exceptionTreeEdgesFromProject);
        HashMap<String, ExceptionsTree> exceptionsTreeByExceptionName = new HashMap<String, ExceptionsTree>();
        this.insertExceptionEdgesIntoTree(allExceptionEdges, exceptionsTreeByExceptionName);
        List<ExceptionsTree> rootNodes = this.getRootNodes(exceptionsTreeByExceptionName);
        rootNodes.forEach(ExceptionsTree::pruneChildren);
        rootNodes.removeIf(ExceptionsTree::shouldBePruned);
        rootNodes.forEach(ExceptionsTree::updateCountValues);
        return rootNodes;
    }

    protected void insertExceptionEdgesIntoTree(List<ExceptionsTreeEdge> exceptionTreeEdges, Map<String, ExceptionsTree> exceptionsTreeByExceptionName) {
        for (ExceptionsTreeEdge edge : exceptionTreeEdges) {
            ExceptionsTree exceptionsChild = ExceptionsTreeManager.getOrCreateExceptionsTreeForChildException(exceptionsTreeByExceptionName, edge);
            ExceptionsTree exceptionsParent = ExceptionsTreeManager.getOrCreateExceptionsTreeForParentException(exceptionsTreeByExceptionName, edge);
            exceptionsParent.addChild(exceptionsChild);
        }
    }

    private static ExceptionsTree getOrCreateExceptionsTreeForChildException(Map<String, ExceptionsTree> exceptionsTreeByExceptionName, ExceptionsTreeEdge edge) {
        if (exceptionsTreeByExceptionName.containsKey(edge.getExceptionName())) {
            ExceptionsTree exceptionNode = exceptionsTreeByExceptionName.get(edge.getExceptionName());
            if (exceptionNode.isParentExceptionUnknown()) {
                exceptionNode.setParentId(edge.getParentExceptionName());
            }
            return exceptionNode;
        }
        return ExceptionsTreeManager.createAndInsertExceptionsTree(edge.getExceptionName(), edge.getParentExceptionName(), edge.getExceptionSource(), exceptionsTreeByExceptionName);
    }

    private static ExceptionsTree getOrCreateExceptionsTreeForParentException(Map<String, ExceptionsTree> exceptionsTreeByException, ExceptionsTreeEdge edge) {
        ExceptionsTree exceptionsTree = exceptionsTreeByException.get(edge.getParentExceptionName());
        if (exceptionsTree == null) {
            ExceptionsTreeManager.createAndInsertExceptionsTree(edge.getParentExceptionName(), null, edge.getExceptionSource(), exceptionsTreeByException);
        }
        return exceptionsTreeByException.get(edge.getParentExceptionName());
    }

    private static ExceptionsTree createAndInsertExceptionsTree(String exceptionName, @Nullable String parentExceptionName, EExceptionSource exceptionSource, Map<String, ExceptionsTree> exceptionsTreeByException) {
        ExceptionsTree exceptionNode = new ExceptionsTree();
        exceptionNode.setName(exceptionName);
        exceptionNode.setExceptionSource(exceptionSource);
        if (parentExceptionName == null) {
            exceptionNode.setParentIdIsUnknown();
        } else {
            exceptionNode.setParentId(parentExceptionName);
        }
        exceptionsTreeByException.put(exceptionName, exceptionNode);
        return exceptionNode;
    }

    private List<ExceptionsTree> getRootNodes(Map<String, ExceptionsTree> exceptionsTreeByExceptionName) {
        ExceptionsTree exceptionsWithUnknownRoot = ExceptionsTreeManager.createAndInsertExceptionsTree(NAME_FOR_EXCEPTIONS_WITHOUT_KNOWN_ROOT, null, EExceptionSource.SYNTHETIC_EXCEPTION, exceptionsTreeByExceptionName);
        ArrayList<ExceptionsTree> exceptionsTrees = new ArrayList<ExceptionsTree>();
        for (ExceptionsTree exceptionsSubTree : exceptionsTreeByExceptionName.values()) {
            if (exceptionsSubTree == exceptionsWithUnknownRoot || !exceptionsSubTree.isParentExceptionUnknown()) continue;
            if (this.languageSupport.isRootException(exceptionsSubTree.getName())) {
                exceptionsTrees.add(exceptionsSubTree);
                continue;
            }
            exceptionsWithUnknownRoot.addChild(exceptionsSubTree);
            exceptionsSubTree.setParentId(exceptionsWithUnknownRoot.getName());
        }
        if (!exceptionsWithUnknownRoot.getChildren().isEmpty()) {
            exceptionsTrees.add(exceptionsWithUnknownRoot);
        }
        return exceptionsTrees;
    }
}

