/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.exceptions_hierarchy;

import com.teamscale.service.audit.exceptions_hierarchy.ExceptionsTreeEdge;
import com.teamscale.service.audit.exceptions_hierarchy.ILanguageSpecificExceptionSupport;
import java.util.HashSet;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ExporterExceptionsDot {
    private static final boolean SHOW_QUALIFIED_NAMES = false;
    private static final String NODE_FORMATTING = " [shape = box, width = 4.0]";
    private static final String EDGE_FORMATTING = " [arrowtail = empty, dir = back]";
    private final ILanguageSpecificExceptionSupport languageSupport;

    public ExporterExceptionsDot(ILanguageSpecificExceptionSupport languageSupport) {
        this.languageSupport = languageSupport;
    }

    public String exportExceptionsHierarchy(List<ExceptionsTreeEdge> edges) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph hierarchy {\n");
        edges.addAll(this.languageSupport.getLanguageSpecificExceptions());
        HashSet<String> nodes = new HashSet<String>();
        for (ExceptionsTreeEdge edge : edges) {
            nodes.add(edge.getExceptionName());
            nodes.add(edge.getParentExceptionName());
        }
        ExporterExceptionsDot.exportNodes(nodes, sb);
        ExporterExceptionsDot.exportEdges(edges, sb);
        sb.append("}");
        return sb.toString();
    }

    private static void exportNodes(HashSet<String> nodes, StringBuilder sb) {
        for (String node : nodes) {
            sb.append(ExporterExceptionsDot.formatClassName(node) + " [shape = box, width = 4.0];\n");
        }
    }

    private static void exportEdges(List<ExceptionsTreeEdge> edges, StringBuilder sb) {
        for (ExceptionsTreeEdge edge : edges) {
            String fromNode = edge.getExceptionName();
            String toNode = edge.getParentExceptionName();
            sb.append(ExporterExceptionsDot.formatClassName(toNode) + " -> " + ExporterExceptionsDot.formatClassName(fromNode) + " [arrowtail = empty, dir = back];\n");
        }
    }

    protected static String formatClassName(String className) {
        String result;
        int dotPosition = className.lastIndexOf(46);
        if (dotPosition == -1) {
            result = className;
        } else {
            CCSMAssert.isFalse((dotPosition + 1 > className.length() ? 1 : 0) != 0, (String)("Class name cannot terminate with a dot: " + className));
            result = className.substring(dotPosition + 1);
        }
        return "\"" + result + "\"";
    }
}

