/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit.exceptions_hierarchy;

import com.teamscale.service.audit.exceptions_hierarchy.EExceptionSource;
import com.teamscale.service.audit.exceptions_hierarchy.ExceptionsTreeEdge;
import com.teamscale.service.audit.exceptions_hierarchy.ILanguageSpecificExceptionSupport;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class JavaSpecificExceptionSupport
implements ILanguageSpecificExceptionSupport {
    @Override
    public Collection<ExceptionsTreeEdge> getLanguageSpecificExceptions() {
        HashSet<ExceptionsTreeEdge> result = new HashSet<ExceptionsTreeEdge>();
        this.collectCoreExceptions(result);
        this.collectFurtherExceptions(result);
        this.collectLibraryExceptions(result);
        return result;
    }

    protected void collectCoreExceptions(Set<ExceptionsTreeEdge> result) {
        result.add(new ExceptionsTreeEdge(Error.class, Throwable.class, EExceptionSource.CORE_OF_LANGUAGE));
        result.add(new ExceptionsTreeEdge(Exception.class, Throwable.class, EExceptionSource.CORE_OF_LANGUAGE));
        result.add(new ExceptionsTreeEdge(RuntimeException.class, Exception.class, EExceptionSource.CORE_OF_LANGUAGE));
    }

    protected void collectFurtherExceptions(Set<ExceptionsTreeEdge> result) {
        Class[] furtherExceptionClasses;
        for (Class cls : furtherExceptionClasses = new Class[]{IOException.class, IllegalStateException.class, SQLException.class}) {
            this.collectExceptionAndSuperExceptions(result, cls, EExceptionSource.LANGUAGE);
        }
    }

    protected void collectLibraryExceptions(Set<ExceptionsTreeEdge> result) {
        result.add(new ExceptionsTreeEdge("org.xml.sax.SAXException", Exception.class, EExceptionSource.POPULAR_LIBRARY));
        result.add(new ExceptionsTreeEdge("com.fasterxml.jackson.core.JsonProcessingException", IOException.class, EExceptionSource.POPULAR_LIBRARY));
    }

    protected void collectExceptionAndSuperExceptions(Set<ExceptionsTreeEdge> result, Class<?> cls, EExceptionSource exceptionSource) {
        try {
            ExceptionsTreeEdge edge;
            for (Class<?> superCls = cls.getSuperclass(); superCls != Throwable.class && !result.contains(edge = new ExceptionsTreeEdge(cls, superCls, exceptionSource)); superCls = superCls.getSuperclass()) {
                result.add(edge);
                cls = superCls;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    @Override
    public boolean isRootException(String simpleExceptionName) {
        return Throwable.class.getSimpleName().equals(simpleExceptionName);
    }
}

