/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.autocomplete;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class EntityFilterHelper<T> {
    private final Function<T, String> filterableStringTransformer;

    public EntityFilterHelper() {
        this(Objects::toString);
    }

    public EntityFilterHelper(Function<? super T, String> filterableStringTransformer) {
        CCSMAssert.isNotNull(filterableStringTransformer);
        Function<? super T, String> casted = filterableStringTransformer;
        this.filterableStringTransformer = casted;
    }

    public Stream<T> filter(Collection<? extends T> input, String searchTerm, boolean regex, int maxResults, Comparator<? super T> comparator) {
        Predicate<T> filter = this.getFilter(searchTerm, regex);
        Stream<? super T> result = input.stream().filter(filter).sorted(comparator).limit(maxResults);
        return result;
    }

    private Predicate<T> getFilter(String searchTerm, boolean regex) {
        if (regex) {
            try {
                Pattern pattern = Pattern.compile(searchTerm, 66);
                return input -> pattern.matcher(this.filterableStringTransformer.apply(input)).find();
            }
            catch (PatternSyntaxException e) {
                return input -> false;
            }
        }
        return input -> this.filterableStringTransformer.apply(input).toLowerCase().contains(searchTerm.toLowerCase());
    }
}

