/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.base;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.utils.HttpRequestUtils;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.admin.instance_import.InstanceCredentials;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.util.BodyPartWrapper;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.logging.TeamscaleLogAppender;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.IProjectIndexWithDynamicName;
import org.conqat.engine.persistence.index.IStorageIndex;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.concurrent.MoreExecutors;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.message.MessageUtils;

public abstract class ApiBase {
    private static final IParallelTaskExecutor PARALLEL_TASK_EXECUTOR = ApiBase.constructParallelTaskExecutor();
    public static final String PROJECT_PATH_PARAMETER = "project";
    public static final String TIMESTAMP_PARAMETER_NAME = "t";
    public static final String TIMESTAMP_PARAMETER_DESCRIPTION = "This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.";
    @Context
    protected ITeamscaleServiceInfo serviceInfo;

    private static IParallelTaskExecutor constructParallelTaskExecutor() {
        int corePoolSize = Integer.getInteger("com.teamscale.service.worker.core-pool-size", 10);
        int maximumPoolSize = Integer.getInteger("com.teamscale.service.worker.maximum-pool-size", 100);
        AtomicInteger threadIndex = new AtomicInteger(1);
        return IParallelTaskExecutor.forExecutorService((ExecutorService)TeamscaleLogAppender.wrap((ExecutorService)MoreExecutors.newCachedThreadPool((int)corePoolSize, (int)maximumPoolSize, (int)1, (TimeUnit)TimeUnit.MINUTES, r -> ApiBase.createWorkerThread(r, threadIndex.getAndIncrement()))));
    }

    private static Thread createWorkerThread(@NonNull Runnable r, int index) {
        return new Thread(r, "Teamscale Service Worker " + index);
    }

    protected IndexLayer getIndexLayer() {
        return this.serviceInfo.getIndexLayer();
    }

    protected GlobalStorageSystem getGlobalStorageSystem() {
        return this.serviceInfo.getGlobalStorageSystem();
    }

    protected CommitResolvingStorageSystem getProjectStorageSystem() {
        return this.serviceInfo.getProjectStorageSystem();
    }

    protected CommitResolvingStorageSystem getProjectStorageSystem(ProjectInfo project) throws StorageException {
        return this.serviceInfo.getProjectStorageSystem((IProjectId)project.getInternalId());
    }

    protected CommitResolvingStorageSystem getProjectStorageSystem(@NonNull IProjectId projectId) throws StorageException {
        return this.serviceInfo.getProjectStorageSystem(projectId);
    }

    protected ServicePermissions getPermissions() {
        return this.serviceInfo.getPermissions();
    }

    protected User getUser() {
        return this.serviceInfo.getUser();
    }

    protected <T extends IProjectIndex> T openProjectIndex(Class<T> indexClass, @Nullable HistoryAccessOption historyAccessOption) throws StorageException {
        return (T)this.getProjectStorageSystem().openProjectIndex(indexClass, historyAccessOption);
    }

    protected <T extends IProjectIndexWithDynamicName> T openProjectIndex(Class<T> indexClass, String indexName, HistoryAccessOption historyAccessOption) throws StorageException {
        return (T)this.getProjectStorageSystem().openProjectIndex(indexClass, indexName, historyAccessOption);
    }

    protected boolean projectIndexExists(String indexName) {
        return this.getProjectStorageSystem().hasIndex(indexName);
    }

    protected <T extends IGlobalIndex> T openGlobalIndex(Class<T> indexClass) throws StorageException {
        return (T)this.getGlobalStorageSystem().openGlobalIndex(indexClass);
    }

    protected IStore openStoreInProject(String name, Class<? extends IStorageIndex> indexClass) throws StorageException {
        CommitResolvingStorageSystem storageSystem = this.getProjectStorageSystem();
        return storageSystem.openStoreChecked(name, indexClass, (IStorageSystem)storageSystem, true, null);
    }

    protected IBranchingLayer openBranchingLayerInProject(String storeName, Class<? extends IStorageIndex> indexClass) throws StorageException {
        CommitResolvingStorageSystem storageSystem = this.getProjectStorageSystem();
        return storageSystem.openBranchingLayer(storeName, indexClass);
    }

    public @NonNull CommitDescriptor resolve(UnresolvedCommitDescriptor unresolvedCommitDescriptor) throws StorageException {
        return UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)unresolvedCommitDescriptor, this::getProjectStorageSystem);
    }

    protected HistoryAccessOption determineHistoryOption(UnresolvedCommitDescriptor unresolvedCommitDescriptor) throws StorageException {
        if (unresolvedCommitDescriptor == null) {
            return this.readDefaultBranchHead();
        }
        return HistoryAccessOption.readCommit((CommitDescriptor)this.resolve(unresolvedCommitDescriptor));
    }

    protected HistoryAccessOption determineHistoryOption(UnresolvedCommitDescriptor unresolvedCommitDescriptor, IProjectId projectId) throws StorageException {
        if (unresolvedCommitDescriptor == null) {
            String defaultBranchName = ApiBase.getDefaultBranchName((ProjectStorageSystem)this.getProjectStorageSystem(projectId));
            if (defaultBranchName != null) {
                return HistoryAccessOption.readHead((String)defaultBranchName);
            }
            return HistoryAccessOption.readHeadUnbranched();
        }
        return HistoryAccessOption.readCommit((CommitDescriptor)UnresolvedCommitDescriptorUtils.resolve((UnresolvedCommitDescriptor)unresolvedCommitDescriptor, () -> this.getProjectStorageSystem(projectId)));
    }

    protected HistoryAccessOption readDefaultBranchHead() throws StorageException {
        String defaultBranchName = this.getDefaultBranchName();
        if (defaultBranchName != null) {
            return HistoryAccessOption.readHead((String)defaultBranchName);
        }
        return HistoryAccessOption.readHeadUnbranched();
    }

    protected String getDefaultBranchName() throws StorageException {
        return ApiBase.getDefaultBranchName((ProjectStorageSystem)this.getProjectStorageSystem());
    }

    protected String getDefaultBranchName(IProjectId projectId) throws StorageException {
        return ApiBase.getDefaultBranchName((ProjectStorageSystem)this.getProjectStorageSystem(projectId));
    }

    public static String getDefaultBranchName(ProjectStorageSystem projectStorageSystem) throws StorageException {
        return ((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getDefaultBranchName();
    }

    protected CommitDescriptor resolveCommitWithFallbackTimestamp(UnresolvedCommitDescriptor commit, long fallbackTimestamp) throws StorageException {
        return UnresolvedCommitDescriptorUtils.resolveCommitWithFallbackTimestamp((UnresolvedCommitDescriptor)commit, (long)fallbackTimestamp, this::getProjectStorageSystem);
    }

    protected List<@NonNull CommitDescriptor> resolveCommits(List<UnresolvedCommitDescriptor> unresolvedCommits) throws StorageException {
        ArrayList<CommitDescriptor> commitDescriptors = new ArrayList<CommitDescriptor>(unresolvedCommits.size());
        for (UnresolvedCommitDescriptor unresolvedCommit : unresolvedCommits) {
            commitDescriptors.add(this.resolve(unresolvedCommit));
        }
        return commitDescriptors;
    }

    protected CommitDescriptorIndex openCommitDescriptorIndex() throws StorageException {
        return this.openProjectIndex(CommitDescriptorIndex.class, null);
    }

    protected CommitDescriptor resolveParent(CommitDescriptor commit) throws StorageException {
        return UnresolvedCommitDescriptorUtils.resolveParent((CommitDescriptor)commit, (CommitDescriptorIndex)this.openCommitDescriptorIndex());
    }

    protected URI createRedirectUri(String location) {
        return URI.create(String.valueOf(this.serviceInfo.getRequestBaseUri()) + StringUtils.stripPrefix((String)location, (String)"/"));
    }

    protected Response.ResponseBuilder createRedirectResponseBuilder(String location) {
        return Response.seeOther((URI)this.createRedirectUri(location));
    }

    protected final IParallelTaskExecutor getParallelTaskExecutor() {
        return PARALLEL_TASK_EXECUTOR;
    }

    protected static String readBodyPart(BodyPart content) throws IOException {
        InputStream inputStream;
        try (InputStream inputStream2 = inputStream = (InputStream)content.getEntityAs(InputStream.class);){
            byte[] array = HttpRequestUtils.readInputStreamEnsuringSizeLimit((InputStream)inputStream, (String)content.getContentDisposition().getFileName());
            Charset encoding = MessageUtils.getCharset((MediaType)content.getMediaType());
            String string = StringUtils.bytesToString((byte[])array, (Charset)encoding);
            return string;
        }
    }

    protected static List<BodyPartWrapper> readFormDataBodyParts(List<FormDataBodyPart> parts) throws IOException {
        ArrayList<BodyPartWrapper> result = new ArrayList<BodyPartWrapper>();
        for (FormDataBodyPart part : parts) {
            FormDataContentDisposition contentDisposition = (FormDataContentDisposition)part.getContentDisposition();
            result.add(new BodyPartWrapper(contentDisposition.getFileName(), ApiBase.readBodyPart((BodyPart)part)));
        }
        return result;
    }

    protected static List<FormDataBodyPart> filterBodyParts(FormDataMultiPart multiPart, String parameterName) {
        ArrayList<FormDataBodyPart> result = new ArrayList<FormDataBodyPart>();
        for (BodyPart part : multiPart.getBodyParts()) {
            FormDataContentDisposition contentDisposition = (FormDataContentDisposition)part.getContentDisposition();
            if (!contentDisposition.getName().equals(parameterName)) continue;
            result.add((FormDataBodyPart)part);
        }
        return result;
    }

    protected InstanceCredentials getRemoteInstanceCredentials(String remoteUrl, String remoteUserName, String remoteAccessToken) throws StorageException {
        if (StringUtils.isEmpty((String)remoteAccessToken)) {
            throw new BadRequestException("Illegal configuration: Remote access token must be supplied.");
        }
        if (StringUtils.isEmpty((String)remoteUserName)) {
            remoteUserName = this.getUser().getUsername();
        }
        return new InstanceCredentials(remoteUrl, remoteUserName, remoteAccessToken);
    }

    protected boolean ensureCommitIsProcessed(boolean assertIfUnprocessed, UnresolvedCommitDescriptor endCommit) throws StorageException {
        if (StringUtils.isEmpty((String)endCommit.getBranchName())) {
            return true;
        }
        boolean isProcessed = this.openProjectIndex(BranchAnalysisStateIndex.class, null).isCommitProcessed(endCommit);
        if (!isProcessed && assertIfUnprocessed) {
            throw new WebApplicationException("The requested commit " + String.valueOf(endCommit) + " has not been processed yet!", Response.Status.PRECONDITION_FAILED);
        }
        return isProcessed;
    }
}

