/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.base;

import com.teamscale.service.base.ESortOrder;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SortOptions {
    private static final String SORT_FIELD_PARAMETER = "sort-by";
    private static final String SORT_ORDER_PARAMETER = "sort-order";
    @Parameter(description="Name of the field to sort entries by")
    @QueryParam(value="sort-by")
    private String sortBy;
    @Parameter(description="The sort order")
    @QueryParam(value="sort-order")
    @DefaultValue(value="ascending")
    private ESortOrder sortOrder;

    public SortOptions() {
    }

    public SortOptions(String sortBy, ESortOrder sortOrder) {
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public ESortOrder getSortOrder() {
        return this.sortOrder;
    }

    public <T> List<T> sort(List<T> results, Function<String, Comparator<T>> fieldComparatorFactory) {
        if (StringUtils.isEmpty((String)this.sortBy)) {
            return results;
        }
        results = CollectionUtils.sort(results, fieldComparatorFactory.apply(this.sortBy));
        if (this.sortOrder == ESortOrder.DESCENDING) {
            return CollectionUtils.reverse((Collection)results);
        }
        return results;
    }
}

