/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.dependencies.ExternalDependencyInfo;
import com.teamscale.index.external.input.ExternalAnalysisImportSessionIndex;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfoDependencyInfo;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfos;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/external-analysis/session/{sessionId}/architecture-dependencies")
public class DependencyUploadService
extends SessionBasedExternalAnalysisServiceBase<SessionBasedExternalAnalysisServiceQueryOptions> {
    @POST
    @Operation(summary="Upload architecture dependencies", description="Adds externally computed architecture dependencies to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", responses={@ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Session has been committed or deleted."), @ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="404", description="No session with provided id found.")}, tags={"Architecture", "External Analysis"})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public void uploadDependencies(@Parameter(description="If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.") @PathParam(value="sessionId") String sessionId, @BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters, @RequestBody(required=true) List<Dependency> dependencies) throws StorageException {
        ArrayList<IExternalUploadRequestPart> uploadRequestParts = new ArrayList<IExternalUploadRequestPart>(dependencies);
        this.process(EHttpMethod.POST, uploadRequestParts, parameters, sessionId);
    }

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionIndex sessionIndex, List<IExternalUploadRequestPart> uploadRequestParts, SessionBasedExternalAnalysisServiceQueryOptions parameters) throws StorageException {
        ExternalAnalysisImportInfos infos = DependencyUploadService.createExternalAnalysisImportInfos(uploadRequestParts);
        sessionIndex.insertAndMergeImportInfos(session, Collections.singletonList(infos));
    }

    private static ExternalAnalysisImportInfos createExternalAnalysisImportInfos(List<IExternalUploadRequestPart> dependencies) {
        HashMap<String, ExternalAnalysisImportInfoDependencyInfo> importInfos = new HashMap<String, ExternalAnalysisImportInfoDependencyInfo>();
        for (IExternalUploadRequestPart requestPart : dependencies) {
            Dependency dependency = (Dependency)requestPart;
            String source = dependency.source;
            ArrayList<TextRegionLocation> locations = new ArrayList<TextRegionLocation>();
            if (dependency.locations != null) {
                for (DependencyLocation location : dependency.locations) {
                    locations.add(new TextRegionLocation(source, -1, -1, location.startLine, location.endLine));
                }
            }
            ExternalAnalysisImportInfoDependencyInfo externalAnalysisImportInfo = importInfos.computeIfAbsent(source, k -> new ExternalAnalysisImportInfoDependencyInfo(source, new ExternalDependencyInfo(new ArrayList())));
            externalAnalysisImportInfo.getData().getDependencies().add(new ExternalDependencyInfo.Dependency(dependency.target, locations));
        }
        return new ExternalAnalysisImportInfos(new ArrayList(importInfos.values()));
    }

    public static class Dependency
    implements IExternalUploadRequestPart {
        private static final String SOURCE_PROPERTY = "source";
        private static final String TARGET_PROPERTY = "target";
        private static final String LOCATIONS_PROPERTY = "locations";
        @JsonProperty(value="source")
        private final String source;
        @JsonProperty(value="target")
        private final String target;
        @JsonProperty(value="locations")
        private final DependencyLocation[] locations;

        @JsonCreator
        public Dependency(@JsonProperty(value="source") String source, @JsonProperty(value="target") String target, @JsonProperty(value="locations") DependencyLocation[] locations) {
            this.source = source;
            this.target = target;
            this.locations = locations;
        }

        public String toString() {
            return this.source + " -> " + this.target;
        }
    }

    public static class DependencyLocation {
        @JsonProperty(value="startLine")
        private int startLine;
        @JsonProperty(value="endLine")
        private int endLine;
    }
}

