/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.tracking.FindingChurnList;
import com.teamscale.index.tracking.index.FindingChurnListIndex;
import com.teamscale.index.tracking.index.TrackedFindingsByIdIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.FindingChurnListDto;
import com.teamscale.service.findings.FindingChurnTruncationParameter;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

@Path(value="api/projects/{project}/finding-churn/list")
public class FindingChurnListService
extends ApiBase {
    @GET
    @Operation(summary="Get finding churn list", description="Provides the findings churn (i.e. the list of added and deleted findings) for a given commit.", tags={"Findings"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_6_4)
    public FindingChurnListDto getFindingChurnList(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.", required=true) @QueryParam(value="t") UnresolvedCommitDescriptor unresolvedCommitDescriptor, @BeanParam FindingChurnTruncationParameter truncationParameter) throws StorageException {
        CommitDescriptor commit;
        FindingChurnListIndex index = this.openProjectIndex(FindingChurnListIndex.class, null);
        FindingChurnList churns = (FindingChurnList)index.getEntry(commit = this.resolve(unresolvedCommitDescriptor));
        if (churns != null) {
            HistoryAccessOption accessHead = HistoryAccessOption.readHead((String)commit.getBranchName());
            this.openProjectIndex(TrackedFindingsByIdIndex.class, accessHead).updateDeathCommits(churns.getAllFindings().values());
            return truncationParameter.truncated(FindingChurnListDto.of(churns));
        }
        return FindingChurnListDto.empty(commit);
    }
}

