/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.help;

import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.log.js.DetailedJavaScriptErrorLog;
import com.teamscale.core.log.js.GlobalJavaScriptErrorLogIndex;
import com.teamscale.core.log.js.ProjectJavaScriptErrorLogIndex;
import com.teamscale.core.log.js.ShortJavaScriptErrorLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.logging.ServiceLoggingUtils;
import com.teamscale.service.help.JavaScriptError;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.date.DateTimeUtils;

@Path(value="api/logs/javascript-errors/report")
public class JavaScriptErrorReportService
extends ApiBase {
    @POST
    @RequiresNoPermission
    @Operation(summary="Report JavaScript error", description="Writes the given JavaScript error that occurred in the Web UI into the Teamscale's JavaScript error log.", tags={"Logging"})
    public void reportJavascriptError(@RequestBody JavaScriptError error) throws StorageException {
        long timestamp = DateTimeUtils.millisNow();
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        Optional projectInfo = error.getProject() == null ? Optional.empty() : projectIndex.tryResolveProject((IProjectId)error.getProject());
        ShortJavaScriptErrorLog shortLog = new ShortJavaScriptErrorLog(LogEntryIdentifier.freshWithTimestamp((long)timestamp), (InternalProjectId)projectInfo.map(ProjectInfo::getInternalId).orElse(null), error.getErrorMessage(), error.getUrl(), this.getLoggedUserName(), error.getUserAgent());
        String message = error.getErrorMessage();
        DetailedJavaScriptErrorLog detailedLog = new DetailedJavaScriptErrorLog(shortLog.getId(), (Collection)CollectionUtils.asHashSet((Object[])new LoggingEventTransport[]{new LoggingEventTransport(message, GlobalJavaScriptErrorLogIndex.JS_LOG_LEVEL, timestamp, null, Collections.emptyMap())}));
        if (projectInfo.isPresent()) {
            this.logToProject(shortLog, detailedLog, ((ProjectInfo)projectInfo.get()).getInternalId());
        } else {
            this.logGlobal(shortLog, detailedLog);
        }
    }

    private void logGlobal(ShortJavaScriptErrorLog shortLog, DetailedJavaScriptErrorLog detailedLog) throws StorageException {
        GlobalJavaScriptErrorLogIndex globalIndex = this.openGlobalIndex(GlobalJavaScriptErrorLogIndex.class);
        globalIndex.insertLog((ShortLogEntryBase)shortLog, (DetailedLogEntryBase)detailedLog);
    }

    private void logToProject(ShortJavaScriptErrorLog shortLog, DetailedJavaScriptErrorLog detailedLog, InternalProjectId projectId) throws StorageException {
        shortLog = new ShortJavaScriptErrorLog(shortLog, projectId);
        CommitResolvingStorageSystem schema = this.getProjectStorageSystem((IProjectId)projectId);
        ProjectJavaScriptErrorLogIndex logIndex = (ProjectJavaScriptErrorLogIndex)schema.openProjectIndex(ProjectJavaScriptErrorLogIndex.class, null);
        logIndex.insertLog((ShortLogEntryBase)shortLog, (DetailedLogEntryBase)detailedLog);
    }

    private String getLoggedUserName() throws StorageException {
        return ServiceLoggingUtils.determineLoggedUserName((boolean)this.serviceInfo.isServiceLogIncludeUsers(), (String)this.getUser().getUsername(), (MetaIndex)this.openGlobalIndex(MetaIndex.class));
    }
}

