/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.license;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.license.License;
import com.teamscale.core.license.LicenseManager;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/license-info")
public class LicenseInfoService
extends ApiBase {
    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Returns information about the license.", description="Returns license information. If the reload parameter is set this reloads the license and logs any errors into the service log.", tags={"License"})
    @ApiResponse(responseCode="204", description="No licenses has been found.")
    public LicenseInfo getLicenseInfo(@Parameter(description="Reload license information") @QueryParam(value="reload") boolean isReloadLicense) {
        LicenseManager licenseManager = LicenseManager.getInstance();
        if (isReloadLicense) {
            licenseManager.reloadLicense();
            try {
                AnalysisProfileUtils.createDefaultAnalysisProfiles((GlobalStorageSystem)this.getGlobalStorageSystem());
            }
            catch (MigrationException | StorageException e) {
                throw new InternalServerErrorException("Error creating default analysis profiles: " + String.valueOf(e), e);
            }
        }
        return new LicenseInfo(licenseManager.getLicense(), licenseManager.getLicenseLocation(), licenseManager.getErrors());
    }

    public static class LicenseInfo {
        @JsonProperty(value="license")
        public @Nullable License license;
        @JsonProperty(value="licenseLocation")
        public @Nullable String licenseLocation;
        @JsonProperty(value="errors")
        public List<String> errors;

        public LicenseInfo(@Nullable License license, @Nullable String licenseLocation, List<String> errors) {
            this.license = license;
            this.licenseLocation = licenseLocation;
            this.errors = new ArrayList<String>(errors);
        }
    }
}

