/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.log.custom.CustomLogConfigurationIndex;
import com.teamscale.core.log.custom.CustomLogEventIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.logging.ELogLevel;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.core.logging.TeamscaleLoggingConfigurationFactory;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/logs/custom")
public class CustomLogsService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    private CustomLogConfigurationIndex openConfigurationIndex() throws StorageException {
        return this.openGlobalIndex(CustomLogConfigurationIndex.class);
    }

    private CustomLogEventIndex openEventIndex() throws StorageException {
        return this.openGlobalIndex(CustomLogEventIndex.class);
    }

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Logging configuration supports custom logs", description="Whether the underlying Log4J configuration supports the custom logs feature.", tags={"Logging", "Debugging"})
    @Path(value="configuration/compatibility")
    public boolean configurationSupportsCustomLogs() {
        return TeamscaleLoggingConfigurationFactory.configurationSupportsCustomLogs();
    }

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get current configuration", description="Outputs the current configuration settings.", tags={"Logging", "Debugging"})
    @Path(value="configuration")
    public LogConfiguration getConfiguration() throws StorageException {
        return LogConfiguration.of(this.openConfigurationIndex().getLoggers());
    }

    @PUT
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Add or update custom logger", description="Adds a new or edits the existing custom logger for the given package with the given log level.", tags={"Logging", "Debugging"})
    @Path(value="configuration/logger")
    public void addOrEditCustomLogger(@RequestBody(required=true) LogConfiguration.ConfigEntry entry) throws StorageException {
        CustomLogConfigurationIndex customLogConfigurationIndex = this.openConfigurationIndex();
        customLogConfigurationIndex.setLogger(entry.name(), entry.level());
        LOGGER.debug("Added custom logger: {}", (Object)entry);
    }

    @DELETE
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Remove logger", description="Removes the logger with the given name.", tags={"Logging", "Debugging"})
    @Path(value="configuration/logger/{loggerName}")
    public void removeCustomLogger(@PathParam(value="loggerName") String loggerName) throws StorageException {
        this.openConfigurationIndex().removeLogger(loggerName);
        LOGGER.debug("Removed custom logger: {}", (Object)loggerName);
    }

    @PUT
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Set the maximum number of log entries", description="Sets the maximum number of log entries stored.", tags={"Logging", "Debugging"})
    @Path(value="configuration/maximumLogEntries")
    public void setMaximumCustomLogCount(@QueryParam(value="count") int count) throws StorageException {
        this.openEventIndex().setMaxSize(count);
    }

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get the maximum number of log entries", description="Gets the maximum number of log entries that are stored.", tags={"Logging", "Debugging"})
    @Path(value="configuration/maximumLogEntries")
    public int getMaximumCustomLogCount() throws StorageException {
        return this.openEventIndex().getMaxSize();
    }

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get custom logs", description="Gets the logs from the custom loggers.", tags={"Logging", "Debugging"})
    public List<LoggingEventTransport> getCustomLogs() throws StorageException {
        return this.openEventIndex().getEvents();
    }

    public record LogConfiguration(List<ConfigEntry> entries) {
        public LogConfiguration(List<ConfigEntry> entries) {
            this.entries = entries = CollectionUtils.asUnmodifiable(new ArrayList<ConfigEntry>((Collection<ConfigEntry>)entries));
        }

        public static LogConfiguration of(Map<String, ELogLevel> entries) {
            return new LogConfiguration(entries.entrySet().stream().map(entry -> new ConfigEntry((String)entry.getKey(), (ELogLevel)entry.getValue())).toList());
        }

        public record ConfigEntry(String name, ELogLevel level) {
        }
    }
}

