/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap;

import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.values.EMetricValueType;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.QueryParam;
import java.awt.Color;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;

public class TreemapQueryOptions {
    public static final String AREA_METRIC_PARAMETER = "area-metric";
    public static final String COLOR_METRIC_PARAMETER = "color-metric";
    private static final String COLOR_PARAMETER = "color";
    private static final Color DEFAULT_COLOR = Color.blue;
    private static final String MAX_VALUE_PARAMETER = "max-value-for-color";
    private static final String MIN_VALUE_PARAMETER = "min-value-for-color";
    private static final String INCLUDED_FILES_PARAMETER = "included-files-regexes";
    private static final String INCLUDED_FILES_DESCRIPTION = "Regular expressions the file paths have to match to be displayed.";
    private static final String EXCLUDED_FILES_PARAMETER = "excluded-files-regexes";
    private static final String EXCLUDED_FILES_DESCRIPTION = "Regular expressions the file paths may not match to be displayed.";
    private static final String DEFAULT_INCLUDE_PATTERN_STRING = ".*";
    private static final String COLOR_METRIC_DESCRIPTION = "The index for the metric used to determine the color of the displayed nodes.";
    public static final String AREA_METRIC_DESCRIPTION = "The index for the metric used to determine the area of the displayed nodes.";
    private static final int VALUE_NOT_SET = -1;
    @QueryParam(value="area-metric")
    @Parameter(description="The index for the metric used to determine the area of the displayed nodes.")
    @DefaultValue(value="-1")
    public int areaMetricIndex;
    @QueryParam(value="color-metric")
    @Parameter(description="The index for the metric used to determine the color of the displayed nodes.")
    @DefaultValue(value="-1")
    public int colorMetricIndex;
    @QueryParam(value="min-value-for-color")
    @DefaultValue(value="-1")
    public double specifiedMinValue;
    @QueryParam(value="max-value-for-color")
    @DefaultValue(value="-1")
    public double specifiedMaxValue;
    @QueryParam(value="color")
    public @Nullable Color baseColorValue;
    @QueryParam(value="included-files-regexes")
    @Parameter(description="Regular expressions the file paths have to match to be displayed.")
    @DefaultValue(value=".*")
    public List<String> includePatternStrings;
    @QueryParam(value="excluded-files-regexes")
    @Parameter(description="Regular expressions the file paths may not match to be displayed.")
    public List<String> excludePatternStrings;
    @QueryParam(value="partition")
    @Parameter(description="The partitions to consider for metric retrieval")
    private Set<String> partitions;
    @QueryParam(value="all-partitions")
    @Parameter(description="Whether all partitions should be included")
    @DefaultValue(value="true")
    private boolean allPartitions;
    @QueryParam(value="color-blind-mode")
    @Parameter(description="Whether to enable the color-blind mode for the Treemap")
    @DefaultValue(value="false")
    private boolean enableColorBlindMode;
    public Object colorMetricDefaultValue;
    public @Nullable Color baseColor;
    public Pattern includePattern;
    public Pattern excludePattern;

    public void postProcess(MetricDirectorySchema schema, boolean isColorMetricRequired) throws InternalServerErrorException {
        this.validate(schema);
        this.initRangeForRatioMetric(schema);
        this.initColors(schema, isColorMetricRequired);
        this.compilePatterns();
    }

    private void initRangeForRatioMetric(MetricDirectorySchema schema) {
        if (this.colorMetricIndex == -1) {
            return;
        }
        boolean isRatioMetric = schema.getEntry(this.colorMetricIndex).getProperties().contains(EMetricProperty.RATIO_METRIC);
        if (isRatioMetric) {
            if (this.specifiedMinValue == -1.0) {
                this.specifiedMinValue = 0.0;
            }
            if (this.specifiedMaxValue == -1.0) {
                this.specifiedMaxValue = 1.0;
            }
        }
    }

    private void initColors(MetricDirectorySchema schema, boolean isColorMetricRequired) {
        this.colorMetricDefaultValue = TreemapQueryOptions.initColorDefault(schema, this.colorMetricIndex, isColorMetricRequired);
        this.baseColor = this.initBaseColor(schema, this.colorMetricIndex);
    }

    private void compilePatterns() throws InternalServerErrorException {
        this.includePattern = TreemapQueryOptions.compileFilePattern(this.includePatternStrings);
        this.excludePattern = TreemapQueryOptions.compileFilePattern(this.excludePatternStrings);
    }

    private void validate(MetricDirectorySchema schema) {
        if (schema.getEntry(this.areaMetricIndex).getValueType() != EMetricValueType.NUMERIC) {
            throw new BadRequestException("Area metric is not numeric");
        }
    }

    public void adjustTreemapRequestOptions(MetricDirectorySchema schema, boolean isColorMetricRequired) {
        this.postProcess(schema, isColorMetricRequired);
    }

    private Color initBaseColor(MetricDirectorySchema schema, int colorMetricIndex) {
        if (this.baseColorValue == null) {
            if (colorMetricIndex != -1) {
                return TreemapQueryOptions.getDefaultColor(schema.getEntry(colorMetricIndex).getName());
            }
            return DEFAULT_COLOR;
        }
        return this.baseColorValue;
    }

    private static Object initColorDefault(MetricDirectorySchema schema, int colorMetricIndex, boolean isColorMetricRequired) {
        Object colorMetricDefaultValue = null;
        if (colorMetricIndex != -1) {
            TreemapQueryOptions.assertColorMetricTypeSupported(schema, colorMetricIndex);
            colorMetricDefaultValue = schema.getEntry(colorMetricIndex).getValueType().getDefaultValue();
        } else if (isColorMetricRequired) {
            throw new BadRequestException("Color metric required but not specified");
        }
        return colorMetricDefaultValue;
    }

    private static Pattern compileFilePattern(List<String> fileRegexes) {
        if (CollectionUtils.isNullOrEmpty(fileRegexes)) {
            return null;
        }
        try {
            return Pattern.compile(TreemapQueryOptions.concatRegexesWithOr(fileRegexes));
        }
        catch (PatternSyntaxException e) {
            throw new BadRequestException("Invalid regular expression used in parameters.", (Throwable)e);
        }
    }

    private static String concatRegexesWithOr(List<String> fileRegexes) {
        return "(" + String.join((CharSequence)")|(", fileRegexes) + ")";
    }

    private static void assertColorMetricTypeSupported(MetricDirectorySchema schema, int colorMetricIndex) {
        EMetricValueType valueType = schema.getEntry(colorMetricIndex).getValueType();
        if (!EMetricValueType.COLOR_METRIC_TYPES.contains(valueType)) {
            throw new BadRequestException("Unsupported metric type for color metric: " + String.valueOf(valueType));
        }
    }

    public @Nullable Set<String> getPartitions() {
        if (this.allPartitions) {
            return null;
        }
        return this.partitions;
    }

    public boolean isColorBlindModeEnabled() {
        return this.enableColorBlindMode;
    }

    private static Color getDefaultColor(String metricName) {
        if ("Line Coverage".equals(metricName)) {
            return ETrafficLightColor.GREEN.getColor(false);
        }
        return Color.blue;
    }
}

