/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.treemap.builder;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.testgap.treemap.RelatedIssuesTreeMapNode;
import com.teamscale.service.metrics.treemap.TreemapSummaryQueryOptions;
import com.teamscale.service.metrics.treemap.builder.IRelatedIssuesMetricTreemapBuilder;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderBase;
import com.teamscale.service.metrics.treemap.builder.MetricTreemapBuilderParameters;
import com.teamscale.service.metrics.treemap.builder.TreeMapBuilderException;
import com.teamscale.service.metrics.treemap.builder.TreemapSummaryUtils;
import com.teamscale.wia.TeamscaleIssueId;
import java.awt.Color;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assessment.Assessment;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class RelatedIssuesMetricTreemapBuilder
extends MetricTreemapBuilderBase<RelatedIssuesTreeMapNode>
implements IRelatedIssuesMetricTreemapBuilder {
    private final SetMap<String, TeamscaleIssueId> issuesByPath;
    private final boolean excludeNonReferencedFiles;
    private final TreemapSummaryQueryOptions treemapSummaryParameters;
    private Object metricOverAll;
    private Object metricOverIssueReferenced;

    public RelatedIssuesMetricTreemapBuilder(IMetricRetrievalStrategy metricRetrievalStrategy, HistoryAccessOption historyAccessOption, int areaMetricIndex, MetricTreemapBuilderParameters parameters, SetMap<UniformPath, TeamscaleIssueId> issuesByPath, boolean excludeNonReferencedFiles, TreemapSummaryQueryOptions treemapSummaryParameters) {
        super(metricRetrievalStrategy, historyAccessOption, areaMetricIndex, parameters);
        this.issuesByPath = issuesByPath.mapKeys(UniformPath::toStringAsMigrationFrontier);
        this.excludeNonReferencedFiles = excludeNonReferencedFiles;
        this.treemapSummaryParameters = treemapSummaryParameters;
    }

    @Override
    protected void afterEntryPreparation(List<MetricDirectoryEntry> entries) throws StorageException {
        MetricAggregator aggregator;
        MetricDirectorySchemaEntry entry = ((MetricDirectorySchema)this.metricDirectorySchemaSupplier.get()).getEntry(this.builderParameters.colorMetricIndex);
        EMetricValueType metricType = entry.getValueType();
        boolean grayIsNeutral = metricType == EMetricValueType.ASSESSMENT && entry.hasProperty(EMetricProperty.EMPTY_ASSESSMENT_IS_NEUTRAL);
        boolean lowIsViolating = metricType == EMetricValueType.NUMERIC && entry.hasProperty(EMetricProperty.LOW_IS_BAD);
        switch (metricType) {
            default: {
                throw new MatchException(null, null);
            }
            case NUMERIC: {
                MetricAggregator metricAggregator = new NumericMetricAggregator(lowIsViolating);
                break;
            }
            case ASSESSMENT: {
                MetricAggregator metricAggregator = new AssessmentAggregator(grayIsNeutral);
                break;
            }
            case TIMESTAMP: 
            case COUNTER_SET: 
            case STRING: {
                MetricAggregator metricAggregator = aggregator = null;
            }
        }
        if (aggregator == null) {
            return;
        }
        this.metricOverAll = aggregator.aggregateOverall(entries);
        this.metricOverIssueReferenced = aggregator.aggregateOverIssueReferenced(entries);
    }

    @Override
    public RelatedIssuesTreeMapNode buildTreemap(UniformPath rootPath) throws TreeMapBuilderException, StorageException {
        return (RelatedIssuesTreeMapNode)super.buildTreeMap(rootPath);
    }

    @Override
    public Object getMetricOverAll() {
        return this.metricOverAll;
    }

    @Override
    public Object getMetricOverIssueReferenced() {
        return this.metricOverIssueReferenced;
    }

    @Override
    protected List<MetricDirectoryEntry> filterEntries(List<MetricDirectoryEntry> entries, String rootPath) {
        if (this.excludeNonReferencedFiles) {
            return this.filterByIncludeExcludePattern(entries, rootPath);
        }
        return super.filterEntries(entries, rootPath);
    }

    @Override
    protected boolean isIncluded(String uniformPath) {
        if (this.excludeNonReferencedFiles && (!this.issuesByPath.containsCollection((Object)uniformPath) || ((Set)this.issuesByPath.getCollection((Object)uniformPath)).isEmpty())) {
            return false;
        }
        return super.isIncluded(uniformPath);
    }

    @Override
    protected RelatedIssuesTreeMapNode createNode(MetricDirectoryEntry entry) throws StorageException {
        return new RelatedIssuesTreeMapNode(entry.getUniformPath(), (Set)this.issuesByPath.getCollectionOrEmpty((Object)entry.getUniformPath()), entry.getDoubleValue(this.areaMetricIndex), this.formatMetricValue(entry.getValueOrDefault(this.builderParameters.colorMetricIndex, this.builderParameters.colorMetricDefault)), this.determineColor(entry));
    }

    @Override
    protected @Nullable Color determineColor(MetricDirectoryEntry entry) throws StorageException {
        if (entry.hasChildren()) {
            return null;
        }
        if (((Set)this.issuesByPath.getCollectionOrEmpty((Object)entry.getUniformPath())).isEmpty()) {
            return Color.GRAY;
        }
        return super.determineColor(entry);
    }

    private class NumericMetricAggregator
    extends MetricAggregator<Double> {
        private DoubleSummaryStatistics tmpAggregatedValue;
        private final boolean lowIsViolating;

        private NumericMetricAggregator(boolean lowIsViolating) {
            this.lowIsViolating = lowIsViolating;
        }

        @Override
        protected void initAggregator() {
            this.tmpAggregatedValue = new DoubleSummaryStatistics();
        }

        @Override
        protected void combineEntry(MetricDirectoryEntry entry) {
            Double areaMetricValue = (Double)entry.getValueOrDefault(RelatedIssuesMetricTreemapBuilder.this.areaMetricIndex, (Object)0.0);
            Double colorMetricValue = (Double)entry.getValueOrDefault(RelatedIssuesMetricTreemapBuilder.this.builderParameters.colorMetricIndex, RelatedIssuesMetricTreemapBuilder.this.builderParameters.colorMetricDefault);
            DoubleSummaryStatistics statisticsToAdd = TreemapSummaryUtils.calculateStatisticsToAdd(RelatedIssuesMetricTreemapBuilder.this.treemapSummaryParameters.getSummaryType(), RelatedIssuesMetricTreemapBuilder.this.treemapSummaryParameters.getViolationThreshold(), this.lowIsViolating, colorMetricValue, areaMetricValue);
            this.tmpAggregatedValue.combine(statisticsToAdd);
        }

        @Override
        protected Double aggregate() {
            return this.tmpAggregatedValue.getAverage();
        }
    }

    private class AssessmentAggregator
    extends MetricAggregator<Assessment> {
        private Assessment tmpAssessment;
        private final boolean grayIsNeutral;

        private AssessmentAggregator(boolean grayIsNeutral) {
            this.grayIsNeutral = grayIsNeutral;
        }

        @Override
        protected void initAggregator() {
            this.tmpAssessment = new Assessment();
        }

        @Override
        protected void combineEntry(MetricDirectoryEntry entry) {
            Assessment colorMetricValue = (Assessment)entry.getValueOrDefault(RelatedIssuesMetricTreemapBuilder.this.builderParameters.colorMetricIndex, RelatedIssuesMetricTreemapBuilder.this.builderParameters.colorMetricDefault);
            int areaMetricValue = ((Double)entry.getValueOrDefault(RelatedIssuesMetricTreemapBuilder.this.areaMetricIndex, (Object)0.0)).intValue();
            switch (RelatedIssuesMetricTreemapBuilder.this.treemapSummaryParameters.getSummaryType()) {
                case AVERAGE_BASED: {
                    this.tmpAssessment.add(colorMetricValue);
                    break;
                }
                case NODE_BASED: {
                    this.tmpAssessment.add(colorMetricValue.getDominantColor());
                    break;
                }
                case AREA_BASED: {
                    this.tmpAssessment.add(colorMetricValue.getDominantColor(), areaMetricValue);
                }
            }
        }

        @Override
        protected Assessment aggregate() {
            if (this.tmpAssessment.getColorFrequency(ETrafficLightColor.UNKNOWN) > 0 && !this.grayIsNeutral) {
                Assessment unknownAssessments = new Assessment();
                unknownAssessments.add(ETrafficLightColor.UNKNOWN, this.tmpAssessment.getColorFrequency(ETrafficLightColor.UNKNOWN));
                this.tmpAssessment.add(ETrafficLightColor.GREEN, unknownAssessments.getSize());
                this.tmpAssessment.subtract(unknownAssessments);
            }
            return this.tmpAssessment;
        }
    }

    private abstract class MetricAggregator<Result> {
        private MetricAggregator() {
        }

        protected abstract void initAggregator();

        protected abstract void combineEntry(MetricDirectoryEntry var1);

        protected abstract Result aggregate();

        public Result aggregateOverall(List<MetricDirectoryEntry> entries) {
            this.initAggregator();
            for (MetricDirectoryEntry entry : entries) {
                if (entry.hasChildren()) continue;
                this.combineEntry(entry);
            }
            return this.aggregate();
        }

        public Result aggregateOverIssueReferenced(List<MetricDirectoryEntry> entries) {
            this.initAggregator();
            for (MetricDirectoryEntry entry : entries) {
                if (entry.hasChildren() || !RelatedIssuesMetricTreemapBuilder.this.issuesByPath.containsCollection((Object)entry.getUniformPath()) || Objects.requireNonNull((Set)RelatedIssuesMetricTreemapBuilder.this.issuesByPath.getCollection((Object)entry.getUniformPath())).isEmpty()) continue;
                this.combineEntry(entry);
            }
            return this.aggregate();
        }
    }
}

