/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.permissions;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.GlobalRole;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/roles/global-roles")
public class GlobalRolesService
extends ApiBase {
    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_ROLES})
    @Operation(summary="Create global role", description="Creates a new global role.", tags={"Permission"})
    public void postGlobalRole(@RequestBody(required=true) GlobalRole newRole) throws StorageException {
        this.getPermissions().createPermissionModifier().setGlobalRole(newRole, "");
    }

    @PUT
    @Path(value="{name}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_ROLES})
    @Operation(summary="Update global role", description="Updates/renames an existing global role. Or creates it as a new role if the parameter for the old global role name is null or an empty string.", tags={"Permission"})
    public void putGlobalRole(@RequestBody(required=true) GlobalRole updatedRole, @Parameter(description="The name of the role to update/rename.") @PathParam(value="name") String oldGlobalRoleName) throws StorageException {
        this.getPermissions().createPermissionModifier().setGlobalRole(updatedRole, oldGlobalRoleName);
    }

    @DELETE
    @Path(value="{name}")
    @RequiresGlobalPermission(value={EGlobalPermission.EDIT_ROLES})
    @Operation(summary="Delete global role", description="Removes an existing global role.", tags={"Permission"})
    public void deleteGlobalRole(@Parameter(description="The name of the role to delete.") @PathParam(value="name") String roleName) throws StorageException {
        this.getPermissions().createPermissionModifier().removeGlobalRole(roleName);
    }
}

