/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.project.analysis_profile;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.QualityIndicatorTemplate;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.configuration.AnalysisProfileVersionedIndex;
import com.teamscale.index.configuration.ProjectValidationUtils;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class AnalysisProfileImportServiceUtils {
    public static ConfigurationTemplate getConfigurationTemplate(EAnalysisTool analysisTool, Set<ELanguage> languages, boolean enableTeamscaleDefaults, Map<String, String> groupToQualityIndicatorMapping, GlobalStorageSystem globalStorageSystem) throws ProjectConfigurationException {
        ConfigurationTemplate template = ConfigRegistry.getInstance().createConfigurationTemplate(languages, Set.of(analysisTool), globalStorageSystem);
        for (Map.Entry<String, String> groupToQualityIndicator : groupToQualityIndicatorMapping.entrySet()) {
            String analysisGroup = groupToQualityIndicator.getKey();
            String qualityIndicatorName = groupToQualityIndicator.getValue();
            QualityIndicatorTemplate qualityIndicator = template.getOrCreateQualityIndicatorTemplate(qualityIndicatorName);
            if (qualityIndicator.getGroupNames().contains((Object)analysisGroup) || template.getAnalysisGroup(analysisGroup) == null) continue;
            qualityIndicator.addGroup(template.getAnalysisGroup(analysisGroup));
        }
        if (!enableTeamscaleDefaults) {
            for (QualityIndicatorTemplate qualityIndicatorTemplate : template.getQualityIndicators()) {
                HashSet<String> groupsToRemove = new HashSet<String>();
                for (String analysisGroupName : qualityIndicatorTemplate.getGroupNames()) {
                    if (groupToQualityIndicatorMapping.containsKey(analysisGroupName)) continue;
                    groupsToRemove.add(analysisGroupName);
                }
                qualityIndicatorTemplate.removeGroups(groupsToRemove);
            }
        }
        return template;
    }

    public static void disableTeamscaleDefaultChecks(Collection<AnalysisGroup> analysisGroups, ConfigurationTemplate configurationTemplate, Set<String> enabledChecks) {
        Set allFindings = configurationTemplate.getAnalysisGroups().stream().flatMap(groupDescriptor -> groupDescriptor.getConfigurationItems().stream().filter(FindingDescriptor.class::isInstance).map(ConfigurationItemBase::getName)).collect(Collectors.toSet());
        for (AnalysisGroup analysisGroup : analysisGroups) {
            for (String option : analysisGroup.getOptionNames()) {
                if (!allFindings.contains(option) || enabledChecks.contains(option)) continue;
                analysisGroup.setOptionValue(option, EFindingEnablement.OFF.toString());
            }
        }
    }

    public static void writeProfile(AnalysisProfile analysisProfile, GlobalStorageSystem globalStorageSystem, ServicePermissions servicePermissions) throws StorageException {
        ProjectValidationUtils.validateAnalysisProfile((AnalysisProfile)analysisProfile, (GlobalStorageSystem)globalStorageSystem, (boolean)true);
        AnalysisProfileVersionedIndex analysisProfileVersionedIndex = (AnalysisProfileVersionedIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileVersionedIndex.class);
        AnalysisProfileIndex analysisProfileIndex = (AnalysisProfileIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileIndex.class);
        AnalysisProfileUtils.updateCurrentProfileSilently((AnalysisProfileVersionedIndex)analysisProfileVersionedIndex, (AnalysisProfileIndex)analysisProfileIndex, (AnalysisProfile)analysisProfile);
        servicePermissions.createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.ANALYSIS_PROFILES, analysisProfile.getName());
    }

    private AnalysisProfileImportServiceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

